/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.containers;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.chickens.blockentities.EggCrackerBlockEntity;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.init.ModContainers;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.containers.PolyBlockContainerMenu;
import net.creeperhost.polylib.containers.slots.PolySlot;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.FluidData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.creeperhost.polylib.data.serializable.LongData;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class EggCrackerMenu
extends PolyBlockContainerMenu<EggCrackerBlockEntity> {
    public final DataSync<FluidStack> tank;
    public final DataSync<Long> energy;
    public final DataSync<Integer> progress;
    public final SlotGroup main;
    public final SlotGroup hotBar;
    public final SlotGroup input;
    public final SlotGroup fluidSlot;
    public final SlotGroup energySlot;
    public final SlotGroup output;

    public EggCrackerMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, (EggCrackerBlockEntity)EggCrackerMenu.getClientTile((Inventory)playerInv, (FriendlyByteBuf)extraData));
    }

    public EggCrackerMenu(int windowId, Inventory playerInv, EggCrackerBlockEntity tile) {
        super((MenuType)ModContainers.EGG_CRACKER.get(), windowId, playerInv, (PolyBlockEntity)tile);
        this.main = Config.INSTANCE.enableEnergy ? this.createSlotGroup(0, new int[]{1, 2, 3}) : this.createSlotGroup(0, new int[]{1, 2});
        this.hotBar = Config.INSTANCE.enableEnergy ? this.createSlotGroup(0, new int[]{1, 2, 3}) : this.createSlotGroup(0, new int[]{1, 2});
        this.input = this.createSlotGroup(1, new int[]{0});
        this.fluidSlot = this.createSlotGroup(2, new int[]{0});
        this.energySlot = this.createSlotGroup(3, new int[]{0});
        this.output = this.createSlotGroup(4, new int[]{0});
        this.tank = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new FluidData(), () -> ((PolyTank)tile.tank).getFluid());
        this.energy = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new LongData(), () -> ((PolyEnergyStorage)tile.energy).getEnergyStored());
        this.progress = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new IntData(), () -> ((IntData)tile.progress).get());
        this.main.addPlayerMain(playerInv);
        this.hotBar.addPlayerBar(playerInv);
        this.input.addSlot(new PolySlot((Container)tile.inventory, 0));
        this.output.addSlots(6, 1, slot -> new PolySlot((Container)tile.inventory, slot.intValue()).output());
        this.fluidSlot.addSlot(new PolySlot((Container)tile.inventory, 7).setStackLimit(e -> 1));
        if (Config.INSTANCE.enableEnergy) {
            this.energySlot.addSlot(new PolySlot((Container)tile.inventory, 8).setStackLimit(e -> 1));
        }
    }
}

