/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.containers;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.chickens.blockentities.IncubatorBlockEntity;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.init.ModContainers;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.containers.PolyBlockContainerMenu;
import net.creeperhost.polylib.containers.slots.PolySlot;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.FloatData;
import net.creeperhost.polylib.data.serializable.FluidData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.creeperhost.polylib.data.serializable.LongData;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class IncubatorMenu
extends PolyBlockContainerMenu<IncubatorBlockEntity> {
    public final DataSync<Float> humidity;
    public final DataSync<Integer> temperature;
    public final DataSync<FluidStack> tank;
    public final DataSync<Integer> heatSetting;
    public final DataSync<Long> energy;
    public final SlotGroup main;
    public final SlotGroup hotBar;
    public final SlotGroup eggSlots;
    public final SlotGroup waterSlot;
    public final SlotGroup energySlot;

    public IncubatorMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, (IncubatorBlockEntity)IncubatorMenu.getClientTile((Inventory)playerInv, (FriendlyByteBuf)extraData));
    }

    public IncubatorMenu(int windowId, Inventory playerInv, IncubatorBlockEntity tile) {
        super((MenuType)ModContainers.INCUBATOR.get(), windowId, playerInv, (PolyBlockEntity)tile);
        this.main = Config.INSTANCE.enableEnergy ? this.createSlotGroup(0, new int[]{1, 2, 3}) : this.createSlotGroup(0, new int[]{1, 2});
        this.hotBar = Config.INSTANCE.enableEnergy ? this.createSlotGroup(0, new int[]{1, 2, 3}) : this.createSlotGroup(0, new int[]{1, 2});
        this.eggSlots = this.createSlotGroup(1, new int[]{0});
        this.waterSlot = this.createSlotGroup(2, new int[]{0});
        this.energySlot = this.createSlotGroup(3, new int[]{0});
        this.humidity = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new FloatData(), () -> ((FloatData)tile.humidity).get());
        this.temperature = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new IntData(), () -> ((IntData)tile.temperature).get());
        this.tank = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new FluidData(), () -> ((PolyTank)tile.tank).getFluid());
        this.heatSetting = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new IntData(), () -> ((IntData)tile.heatSetting).get());
        this.energy = new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new LongData(), () -> ((PolyEnergyStorage)tile.energy).getEnergyStored());
        this.main.addPlayerMain(playerInv);
        this.hotBar.addPlayerBar(playerInv);
        this.eggSlots.addSlots(9, 0, slot -> new PolySlot((Container)tile.inventory, slot.intValue()));
        this.waterSlot.addSlot(new PolySlot((Container)tile.inventory, 9));
        if (Config.INSTANCE.enableEnergy) {
            this.energySlot.addSlot(new PolySlot((Container)tile.inventory, 10));
        }
    }
}

