/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.entity;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.WeakHashMap;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EggTimer {
    private static final WeakHashMap<ItemEntity, Long> EGGS = new WeakHashMap();

    public static void init() {
        EntityEvent.ADD.register(EggTimer::entitySpawn);
        TickEvent.SERVER_PRE.register(EggTimer::serverTick);
    }

    private static EventResult entitySpawn(Entity entity, Level level) {
        ItemChickenEgg egg;
        ItemEntity item;
        ItemStack stack;
        Item item2;
        if (entity instanceof ItemEntity && (item2 = (stack = (item = (ItemEntity)entity).getItem()).getItem()) instanceof ItemChickenEgg && (egg = (ItemChickenEgg)item2).isViable(stack)) {
            EGGS.put(item, System.currentTimeMillis());
        }
        return EventResult.pass();
    }

    private static void serverTick(MinecraftServer server) {
        EGGS.entrySet().removeIf(e -> {
            if (System.currentTimeMillis() > (Long)e.getValue() + (long)Config.INSTANCE.eggItemMaxTimeOnGround * 1000L) {
                ItemStack stack = ((ItemEntity)e.getKey()).getItem();
                Item patt1552$temp = stack.getItem();
                if (patt1552$temp instanceof ItemChickenEgg) {
                    ItemChickenEgg egg = (ItemChickenEgg)patt1552$temp;
                    egg.setNotViable(stack);
                }
                return true;
            }
            return false;
        });
    }
}

