/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.entity;

import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.init.ModSounds;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class EntityChickensChicken
extends Chicken {
    private static final EntityDataAccessor<String> CHICKEN_TYPE = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> CHICKEN_STATS_ANALYZED = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CHICKEN_GROWTH = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CHICKEN_GAIN = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CHICKEN_STRENGTH = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LAY_PROGRESS = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIFE_SPAN = SynchedEntityData.defineId(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String TYPE_NBT = "Type";
    private static final String CHICKEN_STATS_ANALYZED_NBT = "Analyzed";
    private static final String CHICKEN_GROWTH_NBT = "Growth";
    private static final String CHICKEN_GAIN_NBT = "Gain";
    private static final String CHICKEN_STRENGTH_NBT = "Strength";
    private static final String CHICKEN_LIFESPAN_NBT = "Lifespan";
    private final EntityType<?> entityType;

    public EntityChickensChicken(EntityType<? extends Chicken> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.entityType = entityType;
        this.setChickenType(this.getRegistryName(entityType).toString());
        this.setChickenTypeInternal(this.getRegistryName(entityType).toString());
    }

    public boolean checkSpawnRules(LevelAccessor levelAccessor, MobSpawnType mobSpawnType) {
        if (!levelAccessor.getBiome(this.getOnPos()).is(BiomeTags.IS_OVERWORLD)) {
            return true;
        }
        return super.checkSpawnRules(levelAccessor, mobSpawnType);
    }

    public ResourceLocation getRegistryName(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 15.0);
    }

    public boolean getStatsAnalyzed() {
        return (Boolean)this.entityData.get(CHICKEN_STATS_ANALYZED);
    }

    public void setStatsAnalyzed(boolean statsAnalyzed) {
        this.entityData.set(CHICKEN_STATS_ANALYZED, (Object)statsAnalyzed);
    }

    public int getGain() {
        return (Integer)this.entityData.get(CHICKEN_GAIN);
    }

    public void setGain(int gain) {
        this.entityData.set(CHICKEN_GAIN, (Object)gain);
    }

    public int getGrowth() {
        return (Integer)this.entityData.get(CHICKEN_GROWTH);
    }

    public void setGrowth(int growth) {
        this.entityData.set(CHICKEN_GROWTH, (Object)growth);
    }

    public int getStrength() {
        return (Integer)this.entityData.get(CHICKEN_STRENGTH);
    }

    public void setStrength(int strength) {
        this.entityData.set(CHICKEN_STRENGTH, (Object)strength);
    }

    public int getLifeSpan() {
        return (Integer)this.entityData.get(LIFE_SPAN);
    }

    public void setLifeSpan(int lifeSpan) {
        this.entityData.set(LIFE_SPAN, (Object)lifeSpan);
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public int getAmbientSoundInterval() {
        return 40;
    }

    public ResourceLocation getTexture() {
        ChickensRegistryItem chickenDescription = this.getChickenRegistryItem();
        return chickenDescription.getTexture();
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.getRandomIdleSound(this.level());
    }

    public ChickensRegistryItem getChickenRegistryItem() {
        ChickensRegistryItem description = ChickensRegistry.getByRegistryName(this.getRegistryName(this.entityType).toString());
        if (!(description != null && description.isEnabled() || (description = ChickensRegistry.getByResourceLocation(ChickensRegistry.SMART_CHICKEN_ID)).isEnabled())) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return description;
    }

    @Deprecated
    public int getTier() {
        return this.getChickenRegistryItem().getTier();
    }

    public EntityChickensChicken getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageable) {
        boolean mutatingStats;
        ChickensRegistryItem mateChickenDescription;
        EntityChickensChicken mateChicken = (EntityChickensChicken)ageable;
        ChickensRegistryItem chickenDescription = this.getChickenRegistryItem();
        ChickensRegistryItem childToBeBorn = ChickensRegistry.getRandomChild(chickenDescription, mateChickenDescription = mateChicken.getChickenRegistryItem());
        if (childToBeBorn == null) {
            return null;
        }
        EntityChickensChicken newChicken = (EntityChickensChicken)this.entityType.create(this.level());
        newChicken.setChickenType(childToBeBorn.getRegistryName().toString());
        boolean bl = mutatingStats = chickenDescription.getRegistryName() == mateChickenDescription.getRegistryName() && childToBeBorn.getRegistryName() == chickenDescription.getRegistryName();
        if (mutatingStats) {
            EntityChickensChicken.increaseStats(newChicken, this, mateChicken, this.random);
        } else if (chickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, this);
        } else if (mateChickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, mateChicken);
        }
        return newChicken;
    }

    private static void inheritStats(EntityChickensChicken newChicken, EntityChickensChicken parent) {
        newChicken.setGrowth(parent.getGrowth());
        newChicken.setGain(parent.getGain());
        newChicken.setStrength(parent.getStrength());
    }

    private static void increaseStats(EntityChickensChicken newChicken, EntityChickensChicken parent1, EntityChickensChicken parent2, RandomSource rand) {
        int parent1Strength = parent1.getStrength();
        int parent2Strength = parent2.getStrength();
        newChicken.setGrowth(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1.getGrowth(), parent2.getGrowth(), rand));
        newChicken.setGain(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent2.getGain(), parent2.getGain(), rand));
        newChicken.setStrength(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1Strength, parent2Strength, rand));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, RandomSource rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        if (newStatValue <= 1) {
            return 1;
        }
        if (newStatValue >= 10) {
            return 10;
        }
        return newStatValue;
    }

    public void tick() {
        int nearby = this.getNearbyChickens(this.level());
        if (!(this.level().isClientSide || this.isBaby() || this.isChickenJockey())) {
            if (this.getLifeSpan() <= 0) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            int newTimeUntilNextEgg = this.eggTime - 1;
            this.setTimeUntilNextEgg(newTimeUntilNextEgg);
            if (newTimeUntilNextEgg <= 1) {
                ItemStack eggStack;
                boolean viable;
                int damage = Config.INSTANCE.lifespanReductionOnLay;
                if ((double)nearby > Config.INSTANCE.maxChickensInChunk) {
                    damage *= nearby;
                }
                this.setLifeSpan(this.getLifeSpan() - damage);
                ChickensRegistryItem chickenDescription = this.getChickenRegistryItem();
                boolean bl = viable = this.level().random.nextDouble() < Config.INSTANCE.onLaidViabilityChange;
                if ((double)nearby > Config.INSTANCE.maxChickensInChunk) {
                    viable = false;
                }
                if (!(eggStack = ItemChickenEgg.of(chickenDescription, viable)).isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), eggStack);
                    this.level().addFreshEntity((Entity)itemEntity);
                    this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                this.resetTimeUntilNextEgg();
            }
        }
        if (this.level().isClientSide && (double)nearby > Config.INSTANCE.maxChickensInChunk) {
            this.fancy();
        }
        super.tick();
    }

    private void fancy() {
        this.level().addParticle((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
    }

    private int getNearbyChickens(Level level) {
        AABB aabb = this.getBoundingBox().inflate(24.0, 5.0, 24.0);
        return level.getEntities((Entity)this, aabb).size();
    }

    private void setTimeUntilNextEgg(int value) {
        this.eggTime = value;
        this.updateLayProgress();
    }

    @Deprecated
    public int getLayProgress() {
        return (Integer)this.entityData.get(LAY_PROGRESS);
    }

    private void updateLayProgress() {
        this.entityData.set(LAY_PROGRESS, (Object)(this.eggTime / 60 / 20 / 2));
    }

    private void resetTimeUntilNextEgg() {
        ChickensRegistryItem chickenDescription = this.getChickenRegistryItem();
        int newBaseTimeUntilNextEgg = chickenDescription.getMinLayTime() + this.random.nextInt(chickenDescription.getMaxLayTime() - chickenDescription.getMinLayTime());
        int newTimeUntilNextEgg = (int)Math.max(1.0f, (float)newBaseTimeUntilNextEgg * (10.0f - (float)this.getGrowth() + 1.0f) / 10.0f);
        this.setTimeUntilNextEgg(newTimeUntilNextEgg * 2);
    }

    public void setChickenType(String registryName) {
        this.setChickenTypeInternal(registryName);
        this.resetTimeUntilNextEgg();
    }

    private void setChickenTypeInternal(String registryName) {
        this.entityData.set(CHICKEN_TYPE, (Object)registryName);
    }

    private String getChickenTypeInternal() {
        return (String)this.entityData.get(CHICKEN_TYPE);
    }

    public void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(CHICKEN_TYPE, (Object)"");
        this.entityData.define(CHICKEN_GROWTH, (Object)1);
        this.entityData.define(CHICKEN_GAIN, (Object)1);
        this.entityData.define(CHICKEN_STRENGTH, (Object)1);
        this.entityData.define(LAY_PROGRESS, (Object)0);
        this.entityData.define(CHICKEN_STATS_ANALYZED, (Object)false);
        this.entityData.define(LIFE_SPAN, (Object)100);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tagCompound) {
        super.addAdditionalSaveData(tagCompound);
        tagCompound.putString(TYPE_NBT, this.getChickenTypeInternal());
        tagCompound.putBoolean(CHICKEN_STATS_ANALYZED_NBT, this.getStatsAnalyzed());
        tagCompound.putInt(CHICKEN_GROWTH_NBT, this.getGrowth());
        tagCompound.putInt(CHICKEN_GAIN_NBT, this.getGain());
        tagCompound.putInt(CHICKEN_STRENGTH_NBT, this.getStrength());
        tagCompound.putInt(CHICKEN_LIFESPAN_NBT, this.getLifeSpan());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tagCompound) {
        super.readAdditionalSaveData(tagCompound);
        this.setChickenTypeInternal(tagCompound.getString(TYPE_NBT));
        this.setStatsAnalyzed(tagCompound.getBoolean(CHICKEN_STATS_ANALYZED_NBT));
        this.setGrowth(this.getStatusValue(tagCompound, CHICKEN_GROWTH_NBT));
        this.setGain(this.getStatusValue(tagCompound, CHICKEN_GAIN_NBT));
        this.setStrength(this.getStatusValue(tagCompound, CHICKEN_STRENGTH_NBT));
        this.setLifeSpan(this.getStatusValue(tagCompound, CHICKEN_LIFESPAN_NBT));
        this.updateLayProgress();
    }

    private int getStatusValue(CompoundTag compound, String statusName) {
        return compound.contains(statusName) ? compound.getInt(statusName) : 1;
    }
}

