/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.init;

import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.polylib.ItemHolder;
import net.creeperhost.polylib.inventory.fluid.FluidManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ModChickens {
    public static List<ChickensRegistryItem> generateDefaultChickens() {
        ArrayList<ChickensRegistryItem> chickens = new ArrayList<ChickensRegistryItem>();
        chickens.add(new ChickensRegistryItem(ChickensRegistry.VANILLA_CHICKEN, "vanilla_chicken", new ResourceLocation("minecraft", "textures/entity/chicken.png"), new ItemStack((ItemLike)Items.EGG), 0xFFFFFF));
        chickens.add(new ChickensRegistryItem(ChickensRegistry.SMART_CHICKEN_ID, "smart_chicken", new ResourceLocation("chickens", "textures/entity/smart_chicken.png"), new ItemStack((ItemLike)Items.EGG), 0xFFFFFF));
        ChickensRegistryItem whiteChicken = ModChickens.createDyeChicken(DyeColor.WHITE, "white_chicken");
        chickens.add(whiteChicken);
        ChickensRegistryItem yellowChicken = ModChickens.createDyeChicken(DyeColor.YELLOW, "yellow_chicken");
        chickens.add(yellowChicken);
        ChickensRegistryItem blueChicken = ModChickens.createDyeChicken(DyeColor.BLUE, "blue_chicken");
        chickens.add(blueChicken);
        ChickensRegistryItem greenChicken = ModChickens.createDyeChicken(DyeColor.GREEN, "green_chicken");
        chickens.add(greenChicken);
        ChickensRegistryItem redChicken = ModChickens.createDyeChicken(DyeColor.RED, "red_chicken");
        chickens.add(redChicken);
        ChickensRegistryItem blackChicken = ModChickens.createDyeChicken(DyeColor.BLACK, "black_chicken");
        chickens.add(blackChicken);
        ChickensRegistryItem pinkChicken = ModChickens.createDyeChicken(DyeColor.PINK, "pink_chicken").setParentsNew(redChicken, whiteChicken);
        chickens.add(pinkChicken);
        ChickensRegistryItem purpleChicken = ModChickens.createDyeChicken(DyeColor.PURPLE, "purple_chicken").setParentsNew(blueChicken, redChicken);
        chickens.add(purpleChicken);
        chickens.add(ModChickens.createDyeChicken(DyeColor.ORANGE, "orange_chicken").setParentsNew(redChicken, yellowChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIGHT_BLUE, "light_blue_chicken").setParentsNew(whiteChicken, blueChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIME, "lime_chicken").setParentsNew(greenChicken, whiteChicken));
        ChickensRegistryItem grayChicken = ModChickens.createDyeChicken(DyeColor.GRAY, "gray_chicken").setParentsNew(blackChicken, whiteChicken);
        chickens.add(grayChicken);
        chickens.add(ModChickens.createDyeChicken(DyeColor.CYAN, "cyan_chicken").setParentsNew(blueChicken, greenChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIGHT_GRAY, "light_gray_chicken").setParentsNew(grayChicken, whiteChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.MAGENTA, "magenta_chicken").setParentsNew(purpleChicken, pinkChicken));
        ChickensRegistryItem flintChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "flint_chicken"), "flint_chicken", new ResourceLocation("chickens", "textures/entity/flint_chicken.png"), new ItemStack((ItemLike)Items.FLINT), 7039815);
        chickens.add(flintChicken);
        ChickensRegistryItem quartzChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "quartz_chicken"), "quartz_chicken", new ResourceLocation("chickens", "textures/entity/quartz_chicken.png"), new ItemStack((ItemLike)Items.QUARTZ), 0x4D0000);
        chickens.add(quartzChicken);
        ChickensRegistryItem logChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "log_chicken"), "log_chicken", new ResourceLocation("chickens", "textures/entity/log_chicken.png"), new ItemStack((ItemLike)Blocks.OAK_LOG), 9995373);
        chickens.add(logChicken);
        ChickensRegistryItem sandChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "sand_chicken"), "sand_chicken", new ResourceLocation("chickens", "textures/entity/sand_chicken.png"), new ItemStack((ItemLike)Blocks.SAND), 15525297);
        chickens.add(sandChicken);
        ChickensRegistryItem stringChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "string_chicken"), "string_chicken", new ResourceLocation("chickens", "textures/entity/string_chicken.png"), new ItemStack((ItemLike)Items.STRING), 0xFFFFFF, blackChicken, logChicken);
        stringChicken.setLayItem(new ItemStack((ItemLike)Items.STRING));
        chickens.add(stringChicken);
        ChickensRegistryItem glowstoneChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "glowstone_chicken"), "glowstone_chicken", new ResourceLocation("chickens", "textures/entity/glowstone_chicken.png"), new ItemStack((ItemLike)Items.GLOWSTONE_DUST), 0xFFFF66, quartzChicken, yellowChicken);
        chickens.add(glowstoneChicken);
        ChickensRegistryItem gunpowderChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "gunpowder_chicken"), "gunpowder_chicken", new ResourceLocation("chickens", "textures/entity/gunpowder_chicken.png"), new ItemStack((ItemLike)Items.GUNPOWDER), 0x999999, sandChicken, flintChicken);
        chickens.add(gunpowderChicken);
        ChickensRegistryItem redstoneChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "redstone_chicken"), "redstone_chicken", new ResourceLocation("chickens", "textures/entity/redstone_chicken.png"), new ItemStack((ItemLike)Items.REDSTONE), 0xE60000, redChicken, sandChicken);
        chickens.add(redstoneChicken);
        ChickensRegistryItem glassChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "glass_chicken"), "glass_chicken", new ResourceLocation("chickens", "textures/entity/glass_chicken.png"), new ItemStack((ItemLike)Blocks.GLASS), 0xFFFFFF, quartzChicken, redstoneChicken);
        chickens.add(glassChicken);
        ChickensRegistryItem ironChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "iron_chicken"), "iron_chicken", new ResourceLocation("chickens", "textures/entity/iron_chicken.png"), new ItemStack((ItemLike)Items.IRON_INGOT), 0xFFFFCC, flintChicken, whiteChicken);
        chickens.add(ironChicken);
        ChickensRegistryItem coalChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "coal_chicken"), "coal_chicken", new ResourceLocation("chickens", "textures/entity/coal_chicken.png"), new ItemStack((ItemLike)Items.COAL), 0x262626, flintChicken, logChicken);
        chickens.add(coalChicken);
        ChickensRegistryItem brownChicken = ModChickens.createDyeChicken(DyeColor.BROWN, "brown_chicken").setParentsNew(redChicken, greenChicken);
        chickens.add(brownChicken);
        ChickensRegistryItem goldChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "gold_chicken"), "gold_chicken", new ResourceLocation("chickens", "textures/entity/gold_chicken.png"), new ItemStack((ItemLike)Items.GOLD_NUGGET), 0xCCCC00, ironChicken, yellowChicken);
        chickens.add(goldChicken);
        ChickensRegistryItem snowballChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "snowball_chicken"), "snowball_chicken", new ResourceLocation("chickens", "textures/entity/snowball_chicken.png"), new ItemStack((ItemLike)Items.SNOWBALL), 0x33BBFF, blueChicken, logChicken);
        chickens.add(snowballChicken);
        ChickensRegistryItem waterChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "water_chicken"), "water_chicken", new ResourceLocation("chickens", "textures/entity/water_chicken.png"), new ItemHolder("fluid", "minecraft:water", (int)FluidManager.BUCKET), 153, gunpowderChicken, snowballChicken);
        chickens.add(waterChicken);
        ChickensRegistryItem lavaChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "lava_chicken"), "lava_chicken", new ResourceLocation("chickens", "textures/entity/lava_chicken.png"), new ItemHolder("fluid", "minecraft:lava", (int)FluidManager.BUCKET), 0xCC3300, coalChicken, quartzChicken);
        chickens.add(lavaChicken);
        ChickensRegistryItem clayChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "clay_chicken"), "clay_chicken", new ResourceLocation("chickens", "textures/entity/clay_chicken.png"), new ItemStack((ItemLike)Items.CLAY_BALL), 0xCCCCCC, snowballChicken, sandChicken);
        chickens.add(clayChicken);
        ChickensRegistryItem leatherChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "leather_chicken"), "leather_chicken", new ResourceLocation("chickens", "textures/entity/leather_chicken.png"), new ItemStack((ItemLike)Items.LEATHER), 10985580, stringChicken, brownChicken);
        chickens.add(leatherChicken);
        ChickensRegistryItem netherwartChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "netherwart_chicken"), "netherwart_chicken", new ResourceLocation("chickens", "textures/entity/netherwart_chicken.png"), new ItemStack((ItemLike)Items.NETHER_WART), 0x800000, brownChicken, glowstoneChicken);
        chickens.add(netherwartChicken);
        ChickensRegistryItem diamondChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "diamond_chicken"), "diamond_chicken", new ResourceLocation("chickens", "textures/entity/diamond_chicken.png"), new ItemStack((ItemLike)Items.DIAMOND), 0x99CCFF, glassChicken, goldChicken);
        chickens.add(diamondChicken);
        ChickensRegistryItem blazeChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "blaze_chicken"), "blaze_chicken", new ResourceLocation("chickens", "textures/entity/blaze_chicken.png"), new ItemStack((ItemLike)Items.BLAZE_ROD), 0xFFFF66, goldChicken, lavaChicken);
        chickens.add(blazeChicken);
        ChickensRegistryItem slimeChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "slime_chicken"), "slime_chicken", new ResourceLocation("chickens", "textures/entity/slime_chicken.png"), new ItemStack((ItemLike)Items.SLIME_BALL), 39219, clayChicken, greenChicken);
        chickens.add(slimeChicken);
        ChickensRegistryItem enderChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "ender_chicken"), "ender_chicken", new ResourceLocation("chickens", "textures/entity/ender_chicken.png"), new ItemStack((ItemLike)Items.ENDER_PEARL), 6656, diamondChicken, netherwartChicken);
        chickens.add(enderChicken);
        ChickensRegistryItem ghastChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "ghast_chicken"), "ghast_chicken", new ResourceLocation("chickens", "textures/entity/ghast_chicken.png"), new ItemStack((ItemLike)Items.GHAST_TEAR), 0xFFFFCC, whiteChicken, blazeChicken);
        chickens.add(ghastChicken);
        ChickensRegistryItem emeraldChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "emerald_chicken"), "emerald_chicken", new ResourceLocation("chickens", "textures/entity/emerald_chicken.png"), new ItemStack((ItemLike)Items.EMERALD), 52224, diamondChicken, greenChicken);
        chickens.add(emeraldChicken);
        ChickensRegistryItem magmaChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "magma_chicken"), "magma_chicken", new ResourceLocation("chickens", "textures/entity/magma_chicken.png"), new ItemStack((ItemLike)Items.MAGMA_CREAM), 1705216, slimeChicken, blazeChicken);
        chickens.add(magmaChicken);
        ChickensRegistryItem pShardChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "pshard_chicken"), "pshard_chicken", new ResourceLocation("chickens", "textures/entity/pshard_chicken.png"), new ItemStack((ItemLike)Items.PRISMARINE_SHARD), 4423790, waterChicken, blueChicken);
        chickens.add(pShardChicken);
        ChickensRegistryItem pCrystalChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "pcrystal_chicken"), "pcrystal_chicken", new ResourceLocation("chickens", "textures/entity/pcrystal_chicken.png"), new ItemStack((ItemLike)Items.PRISMARINE_CRYSTALS, 1), 5138785, waterChicken, emeraldChicken);
        chickens.add(pCrystalChicken);
        ChickensRegistryItem obsidianChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "obsidian_chicken"), "obsidian_chicken", new ResourceLocation("chickens", "textures/entity/obsidian_chicken.png"), new ItemStack((ItemLike)Blocks.OBSIDIAN, 1), 526350, waterChicken, lavaChicken);
        chickens.add(obsidianChicken);
        ChickensRegistryItem soulSandChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "soulsand_chicken"), "soulsand_chicken", new ResourceLocation("chickens", "textures/entity/soulsand_chicken.png"), new ItemStack((ItemLike)Blocks.SOUL_SAND, 1), 4534565);
        chickens.add(soulSandChicken);
        return chickens;
    }

    public static ChickensRegistryItem createDyeChicken(DyeColor color, String name) {
        DyeItem dyeItem = DyeItem.byColor((DyeColor)color);
        return new ChickensRegistryItem(new ResourceLocation("chickens", name), name, new ResourceLocation("chickens", "textures/entity/" + Strings.join((String[])name.split("(?=[A-Z])"), (String)"_").toLowerCase() + ".png"), new ItemStack((ItemLike)dyeItem, 1), dyeItem.getDyeColor().getFireworkColor());
    }
}

