/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.init;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.creeperhost.chickens.ChickensPlatform;
import net.creeperhost.chickens.api.ChickenStats;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.item.ItemChickenCatcher;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"chickens", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"chickens", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<Item> CHICKEN_ITEM = ITEMS.register("chicken_item", () -> ChickensPlatform.createNewChickenItem(new Item.Properties().stacksTo(16)));
    public static final RegistrySupplier<Item> CATCHER_ITEM = ITEMS.register("catcher", () -> new ItemChickenCatcher(new Item.Properties()));
    public static final RegistrySupplier<Item> CHICKEN_EGG = ITEMS.register("chicken_egg", ItemChickenEgg::new);
    public static final RegistrySupplier<Item> BREEDER = ITEMS.register("breeder", () -> new BlockItem((Block)ModBlocks.BREEDER.get(), new Item.Properties()));
    public static final RegistrySupplier<Item> INCUBATOR = ITEMS.register("incubator", () -> new BlockItem((Block)ModBlocks.INCUBATOR.get(), new Item.Properties()));
    public static final RegistrySupplier<Item> EGG_CRACKER = ITEMS.register("egg_cracker", () -> new BlockItem((Block)ModBlocks.EGG_CRACKER.get(), new Item.Properties()));
    public static final RegistrySupplier<Item> OVOSCOPE = ITEMS.register("ovoscope", () -> new BlockItem((Block)ModBlocks.OVOSCOPE.get(), new Item.Properties()));
    public static final RegistrySupplier<CreativeModeTab> CREATIVE_MODE_TAB = TABS.register("creative_tab", () -> CreativeTabRegistry.create(builder -> builder.title((Component)Component.translatable((String)"itemGroup.chickens.creative_tab")).icon(() -> new ItemStack((ItemLike)ModBlocks.BREEDER.get())).displayItems((itemDisplayParameters, output) -> {
        output.accept((ItemLike)BREEDER.get());
        output.accept((ItemLike)INCUBATOR.get());
        output.accept((ItemLike)EGG_CRACKER.get());
        output.accept((ItemLike)OVOSCOPE.get());
        output.accept((ItemLike)CATCHER_ITEM.get());
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            output.accept(ItemChicken.of(chicken));
            ItemStack stack = ItemChicken.of(chicken);
            ChickenStats chickenStats = new ChickenStats(stack);
            chickenStats.setGain(10);
            chickenStats.setGrowth(10);
            chickenStats.setStrength(10);
            chickenStats.write(stack);
            output.accept(stack);
        }
    })));
    public static final RegistrySupplier<CreativeModeTab> CREATIVE_MODE_TAB_EGGS = TABS.register("creative_tab_eggs", () -> CreativeTabRegistry.create(builder -> builder.title((Component)Component.translatable((String)"itemGroup.chickens.creative_tab_eggs")).icon(() -> new ItemStack((ItemLike)Items.EGG)).displayItems((itemDisplayParameters, output) -> ChickensRegistry.getItems().forEach(e -> output.accept(ItemChickenEgg.of(e))))));
}

