/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.item;

import java.util.List;
import net.creeperhost.chickens.api.ChickenStats;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.init.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemChicken
extends Item {
    public ItemChicken(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(ChickensRegistryItem chickensRegistryItem) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CHICKEN_ITEM.get());
        ItemChicken.applyEntityIdToItemStack(stack, chickensRegistryItem.getRegistryName());
        return stack;
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (!level.isClientSide) {
            InteractionHand hand = useOnContext.getHand();
            ItemStack stack = useOnContext.getPlayer().getItemInHand(hand);
            BlockPos blockPos = ItemChicken.correctPosition(useOnContext.getClickedPos(), useOnContext.getClickedFace());
            ItemChicken.spawn(stack, level, blockPos);
            if (!useOnContext.getPlayer().isCreative()) {
                stack.shrink(1);
            }
        }
        return InteractionResult.PASS;
    }

    public static BlockPos correctPosition(BlockPos pos, Direction side) {
        int[] offsetsXForSide = new int[]{0, 0, 0, 0, -1, 1};
        int[] offsetsYForSide = new int[]{-1, 1, 0, 0, 0, 0};
        int[] offsetsZForSide = new int[]{0, 0, -1, 1, 0, 0};
        int posX = pos.getX() + offsetsXForSide[side.ordinal()];
        int posY = pos.getY() + offsetsYForSide[side.ordinal()];
        int posZ = pos.getZ() + offsetsZForSide[side.ordinal()];
        return new BlockPos(posX, posY, posZ);
    }

    public static void spawn(ItemStack stack, Level worldIn, BlockPos pos) {
        ResourceLocation entityName = ResourceLocation.tryParse((String)ItemChicken.getTypeFromStack(stack));
        EntityChickensChicken entity = (EntityChickensChicken)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityName)).create(worldIn);
        ChickenStats chickenStats = new ChickenStats(stack);
        if (entity == null) {
            return;
        }
        entity.setStatsAnalyzed(true);
        entity.setGain(chickenStats.getGain());
        entity.setStrength(chickenStats.getStrength());
        entity.setGrowth(chickenStats.getGrowth());
        entity.setLifeSpan(chickenStats.getLifespan());
        if (stack.getTag() != null) {
            if (stack.getTag().contains("baby")) {
                entity.setBaby(stack.getTag().getBoolean("baby"));
            }
            if (stack.getTag().contains("love")) {
                entity.setInLoveTime(stack.getTag().getInt("love"));
            }
        }
        entity.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        entity.setChickenType(ItemChicken.getTypeFromStack(stack));
        worldIn.addFreshEntity((Entity)entity);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, level, components, tooltipFlag);
        ChickenStats chickenStats = new ChickenStats(itemStack);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"entity.ChickensChicken.growth").append(" " + chickenStats.getGrowth()).withStyle(ChatFormatting.DARK_PURPLE));
            components.add((Component)Component.translatable((String)"entity.ChickensChicken.gain").append(" " + chickenStats.getGain()).withStyle(ChatFormatting.DARK_PURPLE));
            components.add((Component)Component.translatable((String)"entity.ChickensChicken.strength").append(" " + chickenStats.getStrength()).withStyle(ChatFormatting.DARK_PURPLE));
            components.add((Component)Component.translatable((String)"entity.ChickensChicken.lifespan").append(" " + chickenStats.getLifespan() + "%").withStyle(ChatFormatting.DARK_PURPLE));
        } else {
            components.add((Component)Component.translatable((String)"screen.shift.tooltip"));
        }
    }

    public Component getName(@NotNull ItemStack stack) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemChicken.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return Component.translatable((String)"item.chickens.chicken.name");
        }
        return Component.translatable((String)("entity.chickens." + chickenDescription.getEntityName()));
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        CompoundTag nbttagcompound = stack.hasTag() ? stack.getTag() : new CompoundTag();
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.putString("id", entityId.toString());
        nbttagcompound.put("ChickenType", (Tag)nbttagcompound1);
        stack.setTag(nbttagcompound);
    }

    @Nullable
    public static String getTypeFromStack(ItemStack stack) {
        CompoundTag nbttagcompound = stack.getTag();
        if (nbttagcompound != null && nbttagcompound.contains("ChickenType", 10)) {
            new CompoundTag();
            CompoundTag chickentag = nbttagcompound.getCompound("ChickenType");
            return chickentag.getString("id");
        }
        return null;
    }
}

