/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.polylib;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import net.creeperhost.chickens.Chickens;
import net.creeperhost.chickens.polylib.ItemHolderData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class ItemHolder {
    private String source = null;
    private String type;
    private String itemID;
    private CompoundTag nbtData;
    private boolean isComplete = false;
    private ItemStack stack = ItemStack.EMPTY;
    private int stackSize = 1;
    public static HashMap<String, Integer> ErroredItems = new HashMap();
    Gson gson = new Gson();

    public ItemHolder() {
        this.type = "item";
        this.itemID = this.getRegistryName(Items.AIR).toString();
        this.nbtData = null;
        this.stack = ItemStack.EMPTY;
    }

    public ItemHolder(Item itemIn) {
        this.type = "item";
        this.itemID = this.getRegistryName(itemIn).toString();
        this.nbtData = null;
        this.stack = ItemStack.EMPTY;
    }

    public ItemHolder(ItemStack stackIn, boolean isFinal) {
        this.type = "item";
        this.itemID = this.getRegistryName(stackIn.getItem()).toString();
        this.stack = stackIn;
        this.nbtData = stackIn.hasTag() ? stackIn.getTag() : null;
        this.stackSize = stackIn.getCount();
        this.isComplete = isFinal;
    }

    public ItemHolder(String type, String itemID, int qty) {
        this.type = type;
        this.itemID = itemID;
        this.nbtData = null;
        this.stackSize = qty;
    }

    public ItemHolder(String type, String itemID, String nbt, int qty) {
        this.type = type;
        this.itemID = itemID;
        try {
            this.nbtData = TagParser.parseTag((String)nbt);
        }
        catch (Exception e) {
            this.nbtData = null;
            e.printStackTrace();
        }
        this.stackSize = qty;
    }

    public ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public ResourceLocation getRegistryName(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public ItemHolder setSource(String sourceIn) {
        this.source = sourceIn;
        return this;
    }

    @Nullable
    public Item getItem() {
        if (this.itemID == null) {
            return ItemStack.EMPTY.getItem();
        }
        return (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(this.itemID));
    }

    public Fluid getFluid() {
        if (this.itemID == null) {
            return Fluids.EMPTY;
        }
        return (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(this.itemID));
    }

    public int getStackSize() {
        return !this.stack.isEmpty() ? this.stack.getCount() : this.stackSize;
    }

    public int getAmount() {
        return this.stackSize;
    }

    public ItemStack getStack() {
        if (!this.isComplete) {
            Item item = this.getItem();
            if (item != null) {
                this.stack = new ItemStack((ItemLike)this.getItem(), this.getAmount());
                if (this.nbtData != null && !this.nbtData.isEmpty()) {
                    this.stack.setTag(this.nbtData);
                }
                this.isComplete = true;
            } else {
                this.handleItemNotFound();
                return ItemStack.EMPTY;
            }
        }
        return this.stack.copy();
    }

    private void handleItemNotFound() {
        if (!ErroredItems.containsKey(this.itemID)) {
            ErroredItems.put(this.itemID, 1);
        } else {
            ErroredItems.replace(this.itemID, ErroredItems.get(this.itemID) + 1);
        }
        if (ErroredItems.get(this.itemID) <= 3) {
            Chickens.LOGGER.error("Could not find specfied Item: [" + this.itemID + "]" + (String)(this.hasSource() ? " | Source: [" + this.getSource() + "]" : "") + " | Dropping Default Item: [" + this.stack.getDisplayName() + "]");
            if (ErroredItems.get(this.itemID) == 3) {
                Chickens.LOGGER.error("Will silent error this itemID: [" + this.itemID + "]");
            }
        }
    }

    public ItemHolder readJsonObject(JsonObject data) throws NumberFormatException {
        String nbtString;
        this.itemID = data.has("itemID") ? data.get("itemID").getAsString() : this.getRegistryName(Items.AIR).toString();
        this.stackSize = data.has("qty") ? data.get("qty").getAsInt() : 1;
        String string = nbtString = data.has("nbt") ? data.get("nbt").getAsString() : null;
        if (nbtString != null && !nbtString.isEmpty()) {
            try {
                this.nbtData = TagParser.parseTag((String)nbtString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public JsonObject writeJsonObject(JsonObject data) throws NumberFormatException {
        data.addProperty("itemID", this.itemID);
        if (this.stackSize > 1) {
            data.addProperty("qty", (Number)this.getStackSize());
        }
        if (this.nbtData != null && !this.nbtData.isEmpty()) {
            JsonElement element = (JsonElement)this.gson.fromJson(this.nbtData.toString(), JsonElement.class);
            data.add("nbt", (JsonElement)element.getAsJsonObject());
        }
        return data;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.itemID + ":" + this.stackSize + (String)(this.nbtData != null ? ":" + this.nbtData.toString() : "");
    }

    public ItemHolderData toData() {
        return new ItemHolderData(this.type, this.itemID, this.nbtData == null ? "" : this.nbtData.toString(), this.stackSize);
    }
}

