/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.io.airlift.compress.zstd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.hadoop.HadoopInputStream;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.hadoop.HadoopOutputStream;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.hadoop.HadoopStreams;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.zstd.ZstdHadoopInputStream;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.zstd.ZstdHadoopOutputStream;

public class ZstdHadoopStreams
implements HadoopStreams {
    @Override
    public String getDefaultFileExtension() {
        return ".zst";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.ZStandardCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new ZstdHadoopInputStream(in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZstdHadoopOutputStream(out);
    }
}

