/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.creeperhost.ftbbackups.FTBBackups;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.config.Format;
import net.creeperhost.ftbbackups.repack.io.airlift.compress.zstd.ZstdOutputStream;
import net.creeperhost.ftbbackups.repack.org.kamranzafar.jtar.TarEntry;
import net.creeperhost.ftbbackups.repack.org.kamranzafar.jtar.TarOutputStream;

public class FileUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final double KB_D = 1024.0;
    public static final double MB_D = 1048576.0;
    public static final double GB_D = 1.073741824E9;
    public static final double TB_D = 1.099511627776E12;

    public static void copy(Path outputDirectory, Path serverRoot, Iterable<Path> sourcePaths) throws IOException {
        Path dir = Files.createDirectory(outputDirectory, new FileAttribute[0]);
        for (Path sourcePath : sourcePaths) {
            if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
                Path relFile = serverRoot.relativize(sourcePath);
                if (FileUtils.matchesAny(relFile, Config.cached().excluded)) continue;
                Path destFile = dir.resolve(relFile);
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                Files.copy(sourcePath, destFile, new CopyOption[0]);
                continue;
            }
            Stream<Path> pathStream = Files.walk(sourcePath, new FileVisitOption[0]);
            try {
                for (Path path : pathStream::iterator) {
                    Path relFile;
                    if (Files.isDirectory(path, new LinkOption[0]) || FileUtils.matchesAny(relFile = serverRoot.relativize(path), Config.cached().excluded)) continue;
                    Path destFile = dir.resolve(relFile);
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                    Files.copy(path, destFile, new CopyOption[0]);
                }
            }
            finally {
                if (pathStream == null) continue;
                pathStream.close();
            }
        }
    }

    public static void compress(Path zipFilePath, Path serverRoot, Iterable<Path> sourcePaths, Format format) throws IOException {
        Path p = Files.createFile(zipFilePath, new FileAttribute[0]);
        try (OutputStream f = Files.newOutputStream(p, new OpenOption[0]);
             ZipOutputStream zipOut = format == Format.ZIP ? new ZipOutputStream(f) : null;
             TarOutputStream zstdOut = format == Format.ZSTD ? new TarOutputStream(new ZstdOutputStream(f)) : null;){
            for (Path sourcePath : sourcePaths) {
                if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
                    Path relFile = serverRoot.relativize(sourcePath);
                    if (FileUtils.matchesAny(relFile, Config.cached().excluded)) continue;
                    if (format == Format.ZIP) {
                        FileUtils.packIntoZip(zipOut, serverRoot, sourcePath);
                        continue;
                    }
                    FileUtils.packIntoTar(zstdOut, serverRoot, sourcePath);
                    continue;
                }
                Stream<Path> pathStream = Files.walk(sourcePath, new FileVisitOption[0]);
                try {
                    for (Path path : pathStream::iterator) {
                        Path relFile;
                        if (Files.isDirectory(path, new LinkOption[0]) || FileUtils.matchesAny(relFile = serverRoot.relativize(path), Config.cached().excluded)) continue;
                        if (format == Format.ZIP) {
                            FileUtils.packIntoZip(zipOut, serverRoot, path);
                            continue;
                        }
                        FileUtils.packIntoTar(zstdOut, serverRoot, path);
                    }
                }
                finally {
                    if (pathStream == null) continue;
                    pathStream.close();
                }
            }
        }
    }

    private static boolean shouldSkipPacking(Path file) {
        if (file.getFileName().toString().equals("session.lock")) {
            return true;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        return !Files.isReadable(file);
    }

    private static void packIntoZip(ZipOutputStream zos, Path rootDir, Path file) throws IOException {
        if (FileUtils.shouldSkipPacking(file)) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(rootDir.relativize(file).toString());
        zos.putNextEntry(zipEntry);
        FileUtils.updateZipEntry(zipEntry, file);
        Files.copy(file, zos);
        zos.closeEntry();
    }

    public static void updateZipEntry(ZipEntry zipEntry, Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            zipEntry.setLastModifiedTime(basicFileAttributes.lastModifiedTime());
            zipEntry.setCreationTime(basicFileAttributes.creationTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void packIntoTar(TarOutputStream taos, Path rootDir, Path file) throws IOException {
        if (FileUtils.shouldSkipPacking(file)) {
            return;
        }
        TarEntry tarEntry = new TarEntry(file.toFile(), rootDir.relativize(file).toString());
        taos.putNextEntry(tarEntry);
        FileUtils.updateTarEntry(tarEntry, file);
        try {
            Files.copy(file, taos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateTarEntry(TarEntry tarEntry, Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            tarEntry.setModTime(basicFileAttributes.lastModifiedTime().toMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isChildOf(Path path, Path parent) {
        if (path == null) {
            return false;
        }
        if (path.equals(parent)) {
            return true;
        }
        return FileUtils.isChildOf(path.getParent(), parent);
    }

    public static String getFileSha1(Path path) {
        try {
            HashCode sha1HashCode = com.google.common.io.Files.asByteSource((File)path.toFile()).hash(Hashing.sha1());
            return sha1HashCode.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDirectorySha1(Path directory) {
        try {
            Hasher hasher = Hashing.sha1().newHasher();
            try (Stream<Path> pathStream = Files.walk(directory, new FileVisitOption[0]);){
                for (Path path : pathStream::iterator) {
                    if (Files.isDirectory(path, new LinkOption[0])) continue;
                    HashCode hash = com.google.common.io.Files.asByteSource((File)path.toFile()).hash(Hashing.sha1());
                    hasher.putBytes(hash.asBytes());
                }
            }
            return hasher.hash().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static long getFolderSize(File folder) {
        long length = 0L;
        File[] files = folder.listFiles();
        if (files == null) {
            FTBBackups.LOGGER.warn("Attempt to get folder size for invalid folder: {}", (Object)folder.getAbsolutePath());
            if (folder.isFile()) {
                return folder.length();
            }
            return 0L;
        }
        int count = files.length;
        for (int i = 0; i < count; ++i) {
            if (files[i].isFile()) {
                length += files[i].length();
                continue;
            }
            length += FileUtils.getFolderSize(files[i]);
        }
        return length;
    }

    public static long getFolderSize(Path folder, Predicate<Path> includeFile) {
        long size = 0L;
        try {
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                return Files.size(folder);
            }
            try (Stream<Path> pathStream = Files.walk(folder, new FileVisitOption[0]);){
                for (Path path : pathStream::iterator) {
                    if (Files.isDirectory(path, new LinkOption[0]) || !includeFile.test(path)) continue;
                    size += Files.size(path);
                }
            }
        }
        catch (IOException e) {
            FTBBackups.LOGGER.warn("Error occurred while calculating file size", (Throwable)e);
        }
        return size;
    }

    public static String getSizeString(double b) {
        if (b >= 1.099511627776E12) {
            return String.format("%.1fTB", b / 1.099511627776E12);
        }
        if (b >= 1.073741824E9) {
            return String.format("%.1fGB", b / 1.073741824E9);
        }
        if (b >= 1048576.0) {
            return String.format("%.1fMB", b / 1048576.0);
        }
        if (b >= 1024.0) {
            return String.format("%.1fKB", b / 1024.0);
        }
        return (long)b + "B";
    }

    public static String getSizeString(Path path) {
        return FileUtils.getSizeString(FileUtils.getSize(path.toFile()));
    }

    public static String getSizeString(File file) {
        return FileUtils.getSizeString(FileUtils.getSize(file));
    }

    public static long getSize(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long length = 0L;
            File[] f1 = file.listFiles();
            if (f1 != null && f1.length > 0) {
                for (File aF1 : f1) {
                    length += FileUtils.getSize(aF1);
                }
            }
            return length;
        }
        return 0L;
    }

    public static boolean matchesAny(Path relPath, List<String> filters) {
        for (String filter : filters) {
            boolean ew;
            filter = filter.replaceAll("\\\\", "/");
            boolean directory = filter.endsWith("/");
            boolean sw = filter.startsWith("*");
            if (sw) {
                filter = filter.substring(1);
            }
            boolean bl = ew = filter.endsWith("*") || directory;
            if (ew) {
                filter = filter.substring(0, filter.length() - 1);
            }
            boolean wildCard = sw || ew;
            boolean path = filter.contains("/");
            if (filter.startsWith("/") && !sw) {
                filter = filter.substring(1);
            }
            if (!(!path && !wildCard ? relPath.getFileName().toString().equals(filter) : (path && !wildCard ? relPath.toString().equals(filter) : (sw && ew ? relPath.toString().contains(filter) : (sw ? relPath.toString().endsWith(filter) : relPath.toString().startsWith(filter)))))) continue;
            return true;
        }
        return false;
    }
}

