/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static List<Path> getFilesInFolder(Path folder) {
        return Utils.getFilesInFolder(folder, path -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> getFilesInFolder(Path folder, Predicate<Path> predicate) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.list(folder);){
            List<Path> list = stream.filter(predicate).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Nullable
    public static UUID getUUID(ICompoundTag tag, String name) {
        if (tag.contains(name) && tag.getIntArray(name).length == 4) {
            int[] ints = tag.getIntArray(name);
            return new UUID((long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL, (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL);
        }
        if (tag.contains(name + "Most") && tag.contains(name + "Least")) {
            long most = tag.getLong(name + "Most");
            long least = tag.getLong(name + "Least");
            return new UUID(most, least);
        }
        return null;
    }
}

