/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Entity;
import net.creeperhost.levelio.data.Region;
import net.creeperhost.levelio.data.Section;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.lib.MCAFile;
import net.creeperhost.levelio.lib.SectionStorage;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.creeperhost.levelio.loader.VersionHelper;
import net.creeperhost.levelio.loader.translator.ChunkTranslator;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(Chunk.class);
    public final Region region;
    public final ChunkPos pos;
    public int topSection = Integer.MIN_VALUE;
    public int bottomSection = Integer.MAX_VALUE;
    public int lastModified;
    public int chunkDataVersion = -1;
    public long inhabitedTime = -1L;
    protected final ByteBuffer chunkBuffer;
    protected final ByteBuffer entityBuffer;
    private Path mccFile;
    private SectionStorage sections = new SectionStorage();
    public List<Entity> entities = new ArrayList<Entity>();
    public Map<BlockPos, ICompoundTag> tileData = new HashMap<BlockPos, ICompoundTag>();
    private ICompoundTag chunkTag = null;
    private ICompoundTag entityTag = null;
    private ChunkTranslator translator;

    public Chunk(Region region, ChunkPos pos, MCAFile regionFile, MCAFile entityFile) throws IOException {
        this.region = region;
        this.pos = pos;
        this.lastModified = regionFile.getChunkModifiedTime(pos);
        this.chunkBuffer = regionFile.getChunkBuffer(pos);
        this.entityBuffer = entityFile != null && entityFile.hasChunk(pos) ? entityFile.getChunkBuffer(pos) : null;
        if (Chunk.getCompression(this.chunkBuffer) != -126) {
            this.initTranslator();
        }
    }

    public void setMccFile(Path mccFile) throws IOException {
        this.mccFile = mccFile;
        this.initTranslator();
    }

    public Path getMccFile() {
        return this.mccFile;
    }

    private void initTranslator() throws IOException {
        this.chunkDataVersion = VersionHelper.getChunkDataVersion(this);
        this.translator = VersionHelper.getChunkTranslator(this.chunkDataVersion);
        this.translator.readChunkData(this);
    }

    public void addSection(Section section) {
        this.sections.add(section);
        this.topSection = Math.max(this.topSection, section.getY());
        this.bottomSection = Math.min(this.bottomSection, section.getY());
    }

    public static byte getCompression(ByteBuffer buffer) {
        if (buffer.capacity() < 4) {
            return -115;
        }
        return buffer.get(4);
    }

    public static int getDataLength(ByteBuffer buffer) {
        return buffer.getInt(0) - 1;
    }

    private InputStream getInputStream(ByteBuffer buffer) throws IOException {
        byte compression = Chunk.getCompression(buffer);
        if (compression == -126) {
            if (this.mccFile == null || !Files.exists(this.mccFile, new LinkOption[0])) {
                throw new FileNotFoundException("Did not find an MCC file for chunk " + this.pos + " In level " + this.region.levelInfo);
            }
            return new InflaterInputStream(Files.newInputStream(this.mccFile, new OpenOption[0]));
        }
        ByteArrayInputStream is = new ByteArrayInputStream(buffer.array(), 5, Chunk.getDataLength(buffer));
        if (compression == 0) {
            return is;
        }
        if (compression > 0 && compression <= 2) {
            return compression == 1 ? new GZIPInputStream(is) : new InflaterInputStream(is);
        }
        throw new IllegalStateException("Chunk has an unsupported compression type {" + Chunk.getCompression(buffer) + "}");
    }

    public ICompoundTag getChunkTag() throws IOException {
        if (this.chunkTag == null) {
            try (InputStream is = this.getInputStream(this.chunkBuffer);){
                NBTHandler nbtHandler = this.region.levelIO.nbtHandler;
                this.chunkTag = nbtHandler.read(is);
            }
        }
        return this.chunkTag;
    }

    public ICompoundTag getEntityTag() throws IOException {
        if (this.entityTag == null) {
            if (this.entityBuffer == null) {
                this.entityTag = this.region.levelIO.nbtHandler.emptyCompound();
            } else {
                try (InputStream is = this.getInputStream(this.entityBuffer);){
                    NBTHandler nbtHandler = this.region.levelIO.nbtHandler;
                    this.entityTag = nbtHandler.read(is);
                }
            }
        }
        return this.entityTag;
    }

    public void setChunkTag(ICompoundTag chunkTag) {
        this.chunkTag = chunkTag;
    }

    public Block getBlock(BlockPos pos) {
        int sectionIndex;
        Section section;
        if (this.translator == null) {
            LOGGER.warn("Attempted to retrieve block from a chunk that has not been initialized!");
        }
        if ((section = this.sections.get(sectionIndex = pos.y >> 4)) == null) {
            return Block.newAirBlock();
        }
        return section.getBlock(pos);
    }

    public boolean hasBlock(BlockPos pos) {
        int sectionIndex;
        Section section;
        if (this.translator == null) {
            LOGGER.warn("Attempted to retrieve block from a chunk that has not been initialized!");
        }
        return (section = this.sections.get(sectionIndex = pos.y >> 4)) != null && section.hasBlock(pos);
    }

    @Nullable
    public ICompoundTag getTileData(BlockPos pos) {
        if (this.translator == null) {
            LOGGER.warn("Attempted to retrieve tile from a chunk that has not been initialized!");
        }
        return this.tileData.get(pos);
    }

    @Nullable
    public BlockPos getTopBlock(BlockPos pos) {
        return this.getTopBlock(pos, block -> !block.isAir());
    }

    @Nullable
    public BlockPos getTopBlock(BlockPos pos, Predicate<Block> predicate) {
        int yMax;
        if (this.topSection < this.bottomSection) {
            return null;
        }
        pos = pos.copy();
        int yMin = this.bottomSection << 4;
        for (int y = yMax = (this.topSection << 4) + 15; y >= yMin; --y) {
            Block block;
            pos.y = y;
            if (!this.hasBlock(pos) || !predicate.test(block = this.getBlock(pos))) continue;
            return pos;
        }
        return null;
    }
}

