/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader.translator;

import java.io.IOException;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Entity;
import net.creeperhost.levelio.data.Section;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.loader.translator.ChunkTranslator;

public class TranslatorLegacy
extends ChunkTranslator {
    public static final ChunkTranslator INSTANCE = new TranslatorLegacy();

    @Override
    public void readChunkData(Chunk chunk) throws IOException {
        IListTag entities;
        IListTag tiles;
        ICompoundTag tag = chunk.getChunkTag();
        if ((tag = tag.getCompound("Level")).contains("InhabitedTime")) {
            chunk.inhabitedTime = tag.getLong("InhabitedTime");
        }
        IListTag sections = tag.getList("Sections", 10);
        for (int i = 0; i < sections.size(); ++i) {
            ICompoundTag sectionTag = sections.getCompound(i);
            byte sectionY = sectionTag.getByte("Y");
            Section section = new Section(sectionY, chunk);
            section.setLoader(e -> this.populateSection((Section)e, sectionTag));
            chunk.addSection(section);
        }
        IListTag iListTag = tiles = tag.contains("TileEntities", 10) ? tag.getList("TileEntities", 10) : null;
        if (tiles != null) {
            for (int i = 0; i < tiles.size(); ++i) {
                ICompoundTag tileTag = tiles.getCompound(i);
                chunk.tileData.put(BlockPos.fromTileTag(tileTag), tileTag);
            }
        }
        IListTag iListTag2 = entities = tag.contains("Entities", 10) ? tag.getList("Entities", 10) : null;
        if (entities != null) {
            for (int i = 0; i < entities.size(); ++i) {
                ICompoundTag entityTag = entities.getCompound(i);
                chunk.entities.add(new Entity(entityTag));
            }
        }
    }

    private void populateSection(Section section, ICompoundTag sectionTag) {
        byte[] blocks = sectionTag.getByteArray("Blocks");
        byte[] data = sectionTag.getByteArray("Data");
        byte[] extendedIds = sectionTag.contains("Add") ? sectionTag.getByteArray("Add") : null;
        byte[] extendedIds2 = sectionTag.contains("Add2") ? sectionTag.getByteArray("Add2") : null;
        for (int index = 0; index < 4096; ++index) {
            int x = index & 0xF;
            int y = index >> 8 & 0xF;
            int z = index >> 4 & 0xF;
            int idExtension = extendedIds == null ? 0 : this.getNibble(extendedIds, x, y, z);
            int idExtension2 = extendedIds2 == null ? 0 : this.getNibble(extendedIds2, x, y, z);
            int blockId = idExtension2 << 16 | idExtension << 8 | blocks[index] & 0xFF;
            int meta = this.getNibble(data, x, y, z);
            int blockStateId = idExtension2 << 20 | idExtension << 12 | (blocks[index] & 0xFF) << 4 | this.getNibble(data, x, y, z);
            section.set(index, new Block(blockId, meta));
        }
    }

    public int getNibble(byte[] data, int x, int y, int z) {
        int index = y << 8 | z << 4 | x;
        int i = index >> 1;
        return (index & 1) == 0 ? data[i] & 0xF : data[i] >> 4 & 0xF;
    }

    @Override
    public void writeChunkData(Chunk chunk) throws IOException {
    }
}

