/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.creeperhost.levelio.data.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColourMap {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonData.class, type -> new JsonData()).create();
    private static final Logger LOGGER = LoggerFactory.getLogger(ColourMap.class);
    private Map<String, Integer> COLOUR_BY_NAME = new HashMap<String, Integer>();
    private Map<Integer, Integer> COLOUR_BY_ID = new HashMap<Integer, Integer>();
    private Set<String> unknownBlocks = new HashSet<String>();

    public ColourMap() {
        this.loadColourMapJson(ColourMap.class.getResourceAsStream("/map_colours.json"));
    }

    public void loadColourMapJson(Path path) throws IOException {
        this.loadColourMapJson(Files.newInputStream(path, new OpenOption[0]));
    }

    public void loadColourMapJson(InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            JsonData data = (JsonData)GSON.fromJson((Reader)reader, JsonData.class);
            if (data.legacy) {
                data.blockMap.forEach((idMeta, colour) -> {
                    int id = Integer.parseInt(idMeta.substring(0, idMeta.indexOf(":")));
                    int meta = Integer.parseInt(idMeta.substring(idMeta.indexOf(":") + 1));
                    this.COLOUR_BY_ID.put(id << 4 | meta, (Integer)colour);
                    if (!this.COLOUR_BY_ID.containsKey(id << 4)) {
                        this.COLOUR_BY_ID.put(id << 4, (Integer)colour);
                    }
                });
            } else {
                this.COLOUR_BY_NAME.putAll(data.blockMap);
            }
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred loading colour map json", e);
        }
    }

    public void addBlockMapping(String registryName, int colour) {
        this.COLOUR_BY_NAME.put(registryName, colour);
    }

    public void addBlockMapping(int legacyId, int legacyMeta, int colour) {
        this.COLOUR_BY_ID.put(legacyId << 4 | legacyMeta, colour);
        if (!this.COLOUR_BY_ID.containsKey(legacyId << 4)) {
            this.COLOUR_BY_ID.put(legacyId << 4, colour);
        }
    }

    public int getBlockColour(Block block, int fallBack) {
        String name;
        if (block == null) {
            return fallBack;
        }
        if (block.legacyId != -1) {
            int idMeta = block.legacyId << 4 | block.legacyMeta;
            if (this.COLOUR_BY_ID.containsKey(idMeta)) {
                return 0xFF000000 | this.COLOUR_BY_ID.get(idMeta);
            }
            if (this.COLOUR_BY_ID.containsKey(block.legacyId << 4)) {
                return 0xFF000000 | this.COLOUR_BY_ID.get(block.legacyId << 4);
            }
        }
        if (this.COLOUR_BY_NAME.containsKey(name = block.getName())) {
            return 0xFF000000 | this.COLOUR_BY_NAME.get(name);
        }
        if (block.legacyId == -1 && !this.unknownBlocks.contains(name)) {
            this.unknownBlocks.add(name);
            LOGGER.warn("No colour mapping available for block: {}", (Object)name);
        }
        return fallBack;
    }

    public int getBlockColour(Block block, Brightness brightness, int fallBack) {
        int colour = this.getBlockColour(block, fallBack);
        return brightness.apply(colour);
    }

    public static class JsonData {
        public boolean legacy = false;
        @SerializedName(value="block_map_colours")
        public Map<String, Integer> blockMap = new HashMap<String, Integer>();
    }

    public static enum Brightness {
        LOW(180),
        NORMAL(220),
        HIGH(255);

        private final int value;

        private Brightness(int value) {
            this.value = value;
        }

        public int apply(int colour) {
            int r = (colour >> 16 & 0xFF) * this.value / 255;
            int g = (colour >> 8 & 0xFF) * this.value / 255;
            int b = (colour & 0xFF) * this.value / 255;
            return colour & 0xFF000000 | r << 16 | g << 8 | b;
        }
    }
}

