/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Region;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.lib.MCAFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBTQuickSearch
extends DataInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(NBTQuickSearch.class);
    private static final int END = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int BYTE_ARRAY = 7;
    private static final int STRING = 8;
    private static final int LIST = 9;
    private static final int COMPOUND = 10;
    private static final int INT_ARRAY = 11;
    private static final int LONG_ARRAY = 12;
    private static final int[] TYPE_LENGTH = new int[]{-1, 1, 2, 4, 8, 4, 8, -1, -1, -1, -1, -1, -1};

    public NBTQuickSearch(InputStream is) {
        super(is);
    }

    @Nullable
    public static NBTQuickSearch fromChunk(Region region, ChunkPos pos) throws IOException {
        if (region == null) {
            return null;
        }
        MCAFile mca = region.getRegionMCA();
        ByteBuffer buffer = mca.getChunkBuffer(pos);
        if (buffer.capacity() == 0) {
            return null;
        }
        byte compression = Chunk.getCompression(buffer);
        if (compression == -126) {
            Chunk chunk = region.loadChunk(pos);
            if (chunk == null) {
                return null;
            }
            if (chunk.getMccFile() == null || !Files.exists(chunk.getMccFile(), new LinkOption[0])) {
                LOGGER.warn("Did not find an MCC file for chunk " + pos + " In level " + region.levelInfo);
                return null;
            }
            return new NBTQuickSearch(new InflaterInputStream(Files.newInputStream(chunk.getMccFile(), new OpenOption[0])));
        }
        return NBTQuickSearch.fromChunk(buffer, compression, pos, region);
    }

    private static NBTQuickSearch fromChunk(ByteBuffer buffer, int compression, ChunkPos pos, Region region) {
        InputStream is = new ByteArrayInputStream(buffer.array(), 5, Chunk.getDataLength(buffer));
        if (compression == 1 || compression == 2) {
            try {
                is = compression == 1 ? new GZIPInputStream(is) : new InflaterInputStream(is);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when trying to decompress NBT stream", (Throwable)e);
                return null;
            }
        } else {
            if (compression == 0) {
                return new NBTQuickSearch(is);
            }
            if (compression == -115) {
                LOGGER.warn("NBTQuickSearch found possible broken chunk: {}, in level: {}", (Object)pos, (Object)region.levelInfo.identifier);
            } else {
                LOGGER.warn("NBTQuickSearch found unknown chunk compression type: {}", (Object)compression);
            }
        }
        return null;
    }

    public boolean findTag(String tagName) throws IOException {
        byte id = this.readByte();
        this.readUTF();
        if (id == 10) {
            return this.searchCompound(tagName);
        }
        return false;
    }

    private boolean searchCompound(String tagName) throws IOException {
        block5: while (true) {
            byte id = this.readByte();
            switch (id) {
                case 0: {
                    return false;
                }
                case 10: {
                    this.readUTF();
                    if (!this.searchCompound(tagName)) continue block5;
                    return true;
                }
                case 9: {
                    this.readUTF();
                    if (!this.searchList(tagName)) continue block5;
                    return true;
                }
            }
            String name = this.readUTF();
            if (tagName.equals(name)) {
                return true;
            }
            this.skip(id, 1);
        }
    }

    private boolean searchList(String tagName) throws IOException {
        byte listType = this.readByte();
        int length = this.readInt();
        if (length == 0) {
            return false;
        }
        if (listType == 10) {
            for (int i = 0; i < length; ++i) {
                if (!this.searchCompound(tagName)) continue;
                return true;
            }
        } else if (listType == 9) {
            for (int i = 0; i < length; ++i) {
                if (!this.searchList(tagName)) continue;
                return true;
            }
        } else {
            this.skip(listType, length);
        }
        return false;
    }

    private void skip(int id, int count) throws IOException {
        switch (id) {
            case 7: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt());
                }
                return;
            }
            case 11: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt() * 4);
                }
                return;
            }
            case 12: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt() * 8);
                }
                return;
            }
            case 8: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readUnsignedShort());
                }
                return;
            }
        }
        this.skipBytes(TYPE_LENGTH[id] * count);
    }
}

