/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class Utils {
    public static void waitForTasks(List<Future<?>> activeTasks) {
        while (!activeTasks.isEmpty()) {
            try {
                activeTasks.remove(0).get();
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
    }

    public static <T> void waitForTasks(List<Future<T>> activeTasks, Consumer<T> resultProcessor) {
        while (!activeTasks.isEmpty()) {
            try {
                T result = activeTasks.remove(0).get();
                if (result == null) continue;
                resultProcessor.accept(result);
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
    }

    public static double map(double valueIn, double inMin, double inMax, double outMin, double outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }
}

