/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntangledBinderItem
extends BaseItem {
    public static boolean isBound(ItemStack stack) {
        if (!stack.hasTag()) {
            return false;
        }
        CompoundTag data = stack.getTag();
        if (!(data.getBoolean("bound") && data.contains("dimension", 8) && data.contains("boundx", 3) && data.contains("boundy", 3) && data.contains("boundz", 3))) {
            return false;
        }
        String dimension = data.getString("dimension");
        return RegistryUtil.isValidIdentifier((String)dimension);
    }

    public static BlockPos getBoundPosition(ItemStack stack) {
        CompoundTag data = stack.getTag();
        return new BlockPos(data.getInt("boundx"), data.getInt("boundy"), data.getInt("boundz"));
    }

    public static ResourceLocation getBoundDimension(ItemStack stack) {
        return new ResourceLocation(stack.getTag().getString("dimension"));
    }

    public EntangledBinderItem() {
        super(ItemProperties.create().maxStackSize(1).group(CreativeItemGroup.getToolsAndUtilities()));
    }

    public BaseItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = stack.getTag() == null ? new CompoundTag() : stack.getTag();
        if (compound.getBoolean("bound") && compound.getString("dimension").equals(level.dimension().location().toString()) && compound.getInt("boundx") == hitPos.getX() && compound.getInt("boundy") == hitPos.getY() && compound.getInt("boundz") == hitPos.getZ()) {
            return BaseItem.InteractionFeedback.CONSUME;
        }
        if (!level.isClientSide) {
            compound.putBoolean("bound", true);
            compound.putString("dimension", level.dimension().location().toString());
            compound.putInt("boundx", hitPos.getX());
            compound.putInt("boundy", hitPos.getY());
            compound.putInt("boundz", hitPos.getZ());
            compound.putInt("blockstate", Block.getId((BlockState)level.getBlockState(hitPos)));
            stack.setTag(compound);
            player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.select").color(ChatFormatting.YELLOW).get(), true);
        }
        return BaseItem.InteractionFeedback.SUCCESS;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        CompoundTag compound = stack.getTag();
        if (player.isCrouching() && compound != null && compound.getBoolean("bound")) {
            if (!level.isClientSide) {
                stack.removeTagKey("bound");
                stack.removeTagKey("dimension");
                stack.removeTagKey("boundx");
                stack.removeTagKey("boundy");
                stack.removeTagKey("boundz");
                stack.removeTagKey("blockstate");
                player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.clear").color(ChatFormatting.YELLOW).get(), true);
            }
            return BaseItem.ItemUseResult.consume((ItemStack)stack);
        }
        return super.interact(stack, player, hand, level);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info").color(ChatFormatting.AQUA).get());
        if (EntangledBinderItem.isBound(stack)) {
            CompoundTag tag = stack.getOrCreateTag();
            int x = tag.getInt("boundx");
            int y = tag.getInt("boundy");
            int z = tag.getInt("boundz");
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(tag.getString("dimension")))).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.string((String)Integer.toString(x)).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.string((String)Integer.toString(y)).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.string((String)Integer.toString(z)).color(ChatFormatting.GOLD).get();
            if (tag.contains("blockstate")) {
                MutableComponent name = TextComponents.blockState((BlockState)Block.stateById((int)tag.getInt("blockstate"))).color(ChatFormatting.GOLD).get();
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.known", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            } else {
                info.accept((Component)TextComponents.translation((String)"entangled.entangled_binder.info.target.unknown", (Object[])new Object[]{xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
            }
        }
    }
}

