/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EntangledBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final EnumProperty<State> STATE_PROPERTY = EnumProperty.create((String)"state", State.class);

    public static boolean canBindTo(ResourceLocation blockDimension, BlockPos blockPosition, ResourceLocation targetDimension, BlockPos targetPosition) {
        if (CommonUtils.getLevel((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)targetDimension)) == null) {
            return false;
        }
        if (!blockDimension.equals((Object)targetDimension)) {
            return EntangledConfig.allowDimensional.get();
        }
        if (blockPosition.equals((Object)targetPosition)) {
            return false;
        }
        int maxDistance = EntangledConfig.maxDistance.get();
        return maxDistance == -1 || blockPosition.closerThan((Vec3i)targetPosition, (double)maxDistance + 0.5);
    }

    public EntangledBlock() {
        super(true, BlockProperties.create().mapColor(MapColor.COLOR_BROWN).sound(SoundType.STONE).destroyTime(1.0f).explosionResistance(2.0f).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(STATE_PROPERTY, (Comparable)((Object)State.UNBOUND)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof EntangledBlockEntity)) {
            return BaseBlock.InteractionFeedback.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && stack.isEmpty() && ((EntangledBlockEntity)entity).isBound()) {
            if (!level.isClientSide) {
                ((EntangledBlockEntity)entity).unbind();
                player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.unbind").color(ChatFormatting.YELLOW).get(), true);
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        if (stack.getItem() == Entangled.item) {
            if (!level.isClientSide) {
                if (EntangledBinderItem.isBound(stack)) {
                    ResourceLocation targetDimension = EntangledBinderItem.getBoundDimension(stack);
                    BlockPos targetPos = EntangledBinderItem.getBoundPosition(stack);
                    if (EntangledBlock.canBindTo(level.dimension().location(), pos, targetDimension, targetPos)) {
                        ((EntangledBlockEntity)entity).bind(targetPos, targetDimension);
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.bind").color(ChatFormatting.YELLOW).get(), true);
                    } else if (CommonUtils.getLevel((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)targetDimension)) == null) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.unknown_dimension", (Object[])new Object[]{targetDimension}).color(ChatFormatting.RED).get(), true);
                    } else if (!level.dimension().location().equals((Object)targetDimension) && !EntangledConfig.allowDimensional.get().booleanValue()) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                    } else if (pos.equals((Object)targetPos)) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.self").color(ChatFormatting.RED).get(), true);
                    } else {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                    }
                } else {
                    player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(ChatFormatting.RED).get(), true);
                }
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        return BaseBlock.InteractionFeedback.PASS;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return new EntangledBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STATE_PROPERTY});
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((State)((Object)state.getValue(STATE_PROPERTY))).isBound() ? Shapes.empty() : Shapes.block();
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        MutableComponent maxDistance = TextComponents.string((String)Integer.toString(EntangledConfig.maxDistance.get())).color(ChatFormatting.GOLD).get();
        info.accept((Component)TextComponents.translation((String)("entangled.entangled_block.info." + key), (Object[])new Object[]{maxDistance}).color(ChatFormatting.AQUA).get());
        CompoundTag tag = stack.getOrCreateTag().getCompound("tileData");
        if (tag.contains("bound") && tag.getBoolean("bound")) {
            int x = tag.getInt("boundx");
            int y = tag.getInt("boundy");
            int z = tag.getInt("boundz");
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(tag.getString("dimension")))).color(ChatFormatting.GOLD).get();
            MutableComponent name = TextComponents.blockState((BlockState)Block.stateById((int)tag.getInt("blockstate"))).color(ChatFormatting.GOLD).get();
            MutableComponent xText = TextComponents.string((String)Integer.toString(x)).color(ChatFormatting.GOLD).get();
            MutableComponent yText = TextComponents.string((String)Integer.toString(y)).color(ChatFormatting.GOLD).get();
            MutableComponent zText = TextComponents.string((String)Integer.toString(z)).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"entangled.entangled_block.info.bound", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(ChatFormatting.YELLOW).get());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        CompoundTag compound = stack.getOrCreateTag().getCompound("tileData");
        if (compound.getBoolean("bound")) {
            BlockPos targetPos;
            ResourceLocation targetDimension;
            BlockPos placePos;
            ResourceLocation placeDimension = context.getLevel().dimension().location();
            if (!EntangledBlock.canBindTo(placeDimension, placePos = context.getClickedPos(), targetDimension = new ResourceLocation(compound.getString("dimension")), targetPos = new BlockPos(compound.getInt("boundx"), compound.getInt("boundy"), compound.getInt("boundz")))) {
                Player player = context.getPlayer();
                if (player != null) {
                    if (CommonUtils.getLevel((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)targetDimension)) == null) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_binder.unknown_dimension", (Object[])new Object[]{targetDimension}).color(ChatFormatting.RED).get(), true);
                    } else if (!placeDimension.equals((Object)targetDimension) && !EntangledConfig.allowDimensional.get().booleanValue()) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(ChatFormatting.RED).get(), true);
                    } else if (placePos.equals((Object)targetPos)) {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.self").color(ChatFormatting.RED).get(), true);
                    } else {
                        player.displayClientMessage((Component)TextComponents.translation((String)"entangled.entangled_block.too_far").color(ChatFormatting.RED).get(), true);
                    }
                }
                return null;
            }
            return (BlockState)this.defaultBlockState().setValue(STATE_PROPERTY, (Comparable)((Object)State.BOUND_VALID));
        }
        return this.defaultBlockState();
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.getBlockEntity(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getAnalogOutputSignal() : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.getBlockEntity(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getRedstoneSignal(direction) : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity entity = world.getBlockEntity(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getDirectRedstoneSignal(direction) : 0;
    }

    public static enum State implements StringRepresentable
    {
        UNBOUND,
        BOUND_VALID,
        BOUND_INVALID;


        public boolean isBound() {
            return this != UNBOUND;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

