/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledConfig;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;

public class EntangledBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final TagKey<Block> BLACKLISTED_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("entangled", "invalid_targets"));
    private boolean bound = false;
    private boolean valid = false;
    private boolean revalidate = false;
    private BlockPos boundPos;
    private ResourceKey<Level> boundDimension;
    private BlockState boundBlockState;
    private BlockEntity boundBlockEntity;
    private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private int analogOutputSignal = -1;
    private ICapabilityInvalidationListener capabilityListener;
    private int callDepth = 0;

    public EntangledBlockEntity(BlockPos pos, BlockState state) {
        super(Entangled.tile, pos, state);
    }

    void updateBoundBlockData(boolean forceLoad) {
        if (this.level == null || !this.bound || this.boundPos == null) {
            return;
        }
        Level level = this.getBoundDimension();
        if (level == null) {
            return;
        }
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache && ((ServerChunkCache)chunkSource).mainThread != Thread.currentThread()) {
            return;
        }
        if (this.capabilityListener == null && level instanceof ServerLevel) {
            this.capabilityListener = new ICapabilityInvalidationListener(){

                public boolean onInvalidate() {
                    if (this != EntangledBlockEntity.this.capabilityListener) {
                        return false;
                    }
                    if (EntangledBlockEntity.this.remove) {
                        EntangledBlockEntity.this.capabilityListener = null;
                        return false;
                    }
                    EntangledBlockEntity.this.invalidateCapabilities();
                    return true;
                }
            };
            ((ServerLevel)level).registerCapabilityListener(this.boundPos, this.capabilityListener);
        }
        boolean sendUpdate = false;
        if (forceLoad || chunkSource.getChunkNow(SectionPos.blockToSectionCoord((int)this.boundPos.getX()), SectionPos.blockToSectionCoord((int)this.boundPos.getZ())) != null) {
            BlockState state = level.getBlockState(this.boundPos);
            BlockEntity entity = level.getBlockEntity(this.boundPos);
            int analogOutputSignal = state.hasAnalogOutputSignal() ? state.getAnalogOutputSignal(level, this.boundPos) : 0;
            boolean signalChanged = false;
            for (Direction direction : Direction.values()) {
                int redstoneSignal = state.getSignal((BlockGetter)level, this.boundPos, direction);
                int directRedstoneSignal = state.getDirectSignal((BlockGetter)level, this.boundPos, direction);
                if (redstoneSignal == this.redstoneSignal[direction.get3DDataValue()] && directRedstoneSignal == this.directRedstoneSignal[direction.get3DDataValue()]) continue;
                signalChanged = true;
                this.redstoneSignal[direction.get3DDataValue()] = redstoneSignal;
                this.directRedstoneSignal[direction.get3DDataValue()] = directRedstoneSignal;
            }
            if (state != this.boundBlockState || entity != this.boundBlockEntity || analogOutputSignal != this.analogOutputSignal || signalChanged) {
                this.boundBlockState = state;
                this.boundBlockEntity = entity;
                this.analogOutputSignal = analogOutputSignal;
                if (!this.level.isClientSide) {
                    this.valid = this.isValidBlock(state);
                }
                sendUpdate = true;
            }
        } else if (this.boundBlockEntity != null && this.boundBlockEntity.isRemoved()) {
            this.boundBlockEntity = null;
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.updateStateAndNeighbors();
            this.dataChanged();
        }
    }

    public void update() {
        boolean forceLoad = !this.level.isClientSide && (this.boundBlockState == null || (this.boundBlockEntity != null ? this.boundBlockEntity.isRemoved() : this.boundBlockState.hasBlockEntity()) || this.analogOutputSignal == -1);
        this.updateBoundBlockData(forceLoad);
        if (!this.level.isClientSide && this.revalidate) {
            if (this.bound) {
                this.valid = this.boundBlockState != null && this.isValidBlock(this.boundBlockState);
                this.updateStateAndNeighbors();
            }
            this.revalidate = false;
        }
    }

    private boolean isValidBlock(BlockState state) {
        return EntangledConfig.useWhitelist.get().booleanValue() == state.is(BLACKLISTED_BLOCKS);
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isBoundAndValid() {
        return this.bound && this.valid;
    }

    @Nullable
    public BlockPos getBoundBlockPos() {
        return this.boundPos;
    }

    public ResourceKey<Level> getBoundDimensionIdentifier() {
        return this.boundDimension;
    }

    public BlockState getBoundBlockState() {
        return this.boundBlockState;
    }

    public <A, C> A getCapability(BlockCapability<A, C> capability, C context) {
        if (this.isBoundAndValid() && this.callDepth < 10) {
            if (this.boundBlockEntity == null ? this.boundBlockState == null || this.boundBlockState.hasBlockEntity() : this.boundBlockEntity.isRemoved()) {
                this.updateBoundBlockData(false);
            }
            if (this.boundBlockEntity != null && !this.boundBlockEntity.isRemoved()) {
                ++this.callDepth;
                Object value = this.getBoundDimension().getCapability(capability, this.boundPos, this.boundBlockState, this.boundBlockEntity, context);
                --this.callDepth;
                return (A)value;
            }
        }
        return null;
    }

    public void bind(BlockPos pos, ResourceLocation dimension) {
        this.bound = true;
        this.valid = true;
        this.boundPos = new BlockPos((Vec3i)pos);
        this.boundDimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension);
        this.boundBlockState = null;
        this.boundBlockEntity = null;
        this.updateStateAndNeighbors();
        this.dataChanged();
    }

    public void unbind() {
        this.bound = false;
        this.valid = true;
        this.boundPos = null;
        this.boundDimension = null;
        this.boundBlockState = null;
        this.boundBlockEntity = null;
        this.updateStateAndNeighbors();
        this.dataChanged();
    }

    private void updateStateAndNeighbors() {
        if (this.level.isClientSide) {
            return;
        }
        EntangledBlock.State properState = this.bound && this.valid ? EntangledBlock.State.BOUND_VALID : (this.bound ? EntangledBlock.State.BOUND_INVALID : EntangledBlock.State.UNBOUND);
        this.capabilityListener = null;
        if (this.getBlockState().getValue(EntangledBlock.STATE_PROPERTY) != properState) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(EntangledBlock.STATE_PROPERTY, (Comparable)((Object)properState)));
        } else {
            this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
        this.invalidateCapabilities();
    }

    Level getBoundDimension() {
        if (!this.isBound() || this.boundDimension == null) {
            return null;
        }
        return this.level.isClientSide ? (this.level.dimension() == this.boundDimension ? this.level : null) : this.level.getServer().getLevel(this.boundDimension);
    }

    private boolean isTargetLoaded() {
        if (this.level.isClientSide || !this.isBound()) {
            return false;
        }
        Level level = this.level.dimension() == this.boundDimension ? this.level : this.level.getServer().getLevel(this.boundDimension);
        return level != null && level.isLoaded(this.boundPos);
    }

    public int getRedstoneSignal(Direction side) {
        if (!this.isBoundAndValid()) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.redstoneSignal[side.get3DDataValue()] = level.getBlockState(this.boundPos).getSignal((BlockGetter)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.redstoneSignal[side.get3DDataValue()], 0);
        }
        return Math.max(this.redstoneSignal[side.get3DDataValue()], 0);
    }

    public int getDirectRedstoneSignal(Direction side) {
        if (!this.isBoundAndValid()) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.directRedstoneSignal[side.get3DDataValue()] = level.getBlockState(this.boundPos).getDirectSignal((BlockGetter)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.directRedstoneSignal[side.get3DDataValue()], 0);
        }
        return Math.max(this.directRedstoneSignal[side.get3DDataValue()], 0);
    }

    public int getAnalogOutputSignal() {
        if (!this.isBoundAndValid()) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.analogOutputSignal = level.getBlockState(this.boundPos).getAnalogOutputSignal(level, this.boundPos);
            --this.callDepth;
            return Math.max(this.analogOutputSignal, 0);
        }
        return Math.max(this.analogOutputSignal, 0);
    }

    public void load(CompoundTag compound) {
        if (compound.contains("bound")) {
            CompoundTag data = new CompoundTag();
            data.putBoolean("bound", compound.getBoolean("bound"));
            data.putInt("boundx", compound.getInt("boundx"));
            data.putInt("boundy", compound.getInt("boundy"));
            data.putInt("boundz", compound.getInt("boundz"));
            data.putString("dimension", compound.getString("dimension"));
            compound.put("data", (Tag)data);
        }
        super.load(compound);
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        if (this.bound) {
            compound.putBoolean("bound", true);
            compound.putBoolean("valid", this.valid);
            compound.putInt("boundx", this.boundPos.getX());
            compound.putInt("boundy", this.boundPos.getY());
            compound.putInt("boundz", this.boundPos.getZ());
            compound.putString("dimension", this.boundDimension.location().toString());
            compound.putInt("blockstate", Block.getId((BlockState)this.boundBlockState));
            for (Direction direction : Direction.values()) {
                int index = direction.get3DDataValue();
                compound.putInt("redstoneSignal" + index, this.redstoneSignal[index]);
                compound.putInt("directRedstoneSignal" + index, this.directRedstoneSignal[index]);
            }
            compound.putInt("analogOutputSignal", this.analogOutputSignal);
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.bound = compound.getBoolean("bound");
        if (this.bound) {
            this.valid = !compound.contains("valid", 1) || compound.getBoolean("valid");
            this.revalidate = true;
            this.boundPos = new BlockPos(compound.getInt("boundx"), compound.getInt("boundy"), compound.getInt("boundz"));
            this.boundDimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(compound.getString("dimension")));
            this.boundBlockState = Block.stateById((int)compound.getInt("blockstate"));
            for (Direction direction : Direction.values()) {
                int index = direction.get3DDataValue();
                this.redstoneSignal[index] = compound.getInt("redstoneSignal" + index);
                this.directRedstoneSignal[index] = compound.getInt("directRedstoneSignal" + index);
            }
            this.analogOutputSignal = compound.getInt("analogOutputSignal");
        }
    }
}

