/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;

public class EntangledBlockEntityRenderer
implements CustomBlockEntityRenderer<EntangledBlockEntity> {
    public static final TagKey<Block> BLACKLISTED_BLOCKS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)new ResourceLocation("entangled", "render_blacklist"));
    public static final TagKey<BlockEntityType<?>> BLACKLISTED_ENTITIES = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)new ResourceLocation("entangled", "render_blacklist"));
    private static final Set<BlockEntityType<?>> ERRORED_BLOCK_ENTITIES = Collections.synchronizedSet(new HashSet());
    private static final Set<BlockState> ERRORED_BLOCK_STATES = Collections.synchronizedSet(new HashSet());
    private static int depth = 0;

    public void render(EntangledBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        VoxelShape shape;
        if (!entity.isBound()) {
            return;
        }
        BlockEntity boundTile = entity.getLevel().dimension() == entity.getBoundDimensionIdentifier() ? entity.getLevel().getBlockEntity(entity.getBoundBlockPos()) : null;
        BlockState boundState = entity.getBoundBlockState();
        boolean renderTile = boundTile != null && BuiltInRegistries.BLOCK_ENTITY_TYPE.getTag(BLACKLISTED_ENTITIES).map(tag -> tag.contains((Holder)BuiltInRegistries.BLOCK_ENTITY_TYPE.getHolder(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)boundTile.getType()))).orElseThrow())).orElse(false) == false && !ERRORED_BLOCK_ENTITIES.contains(boundTile.getType());
        boolean renderBlock = boundState != null && boundState.getRenderShape() == RenderShape.MODEL && !boundState.is(BLACKLISTED_BLOCKS) && !ERRORED_BLOCK_STATES.contains(boundState);
        AABB bounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && entity.getLevel().dimension() == entity.getBoundDimensionIdentifier() && !(shape = boundState.getOcclusionShape((BlockGetter)entity.getLevel(), entity.getBoundBlockPos())).isEmpty()) {
            bounds = shape.bounds();
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (EntangledConfig.rotateRenderedBlock.get().booleanValue()) {
            float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 2.0f * (float)Math.PI;
            float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 2.0f * (float)Math.PI;
            float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 2.0f * (float)Math.PI;
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleX, 1.0f, 0.0f, 0.0f));
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleY, 0.0f, 1.0f, 0.0f));
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleZ, 0.0f, 0.0f, 1.0f));
        }
        float scale = 0.4763f / (float)Math.sqrt((bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize()) / 4.0);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-bounds.getCenter().x, -bounds.getCenter().y, -bounds.getCenter().z);
        if (renderTile && (!(boundTile instanceof EntangledBlockEntity) || depth < 10)) {
            ++depth;
            try {
                ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().render(boundTile, partialTicks, poseStack, bufferSource);
            }
            catch (Exception e) {
                ERRORED_BLOCK_ENTITIES.add(boundTile.getType());
                Entangled.LOGGER.error("Encountered an exception whilst rendering block entity '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier((Object)boundTile.getType()) + "'! Please report to Entangled!", (Throwable)e);
            }
            --depth;
        }
        if (renderBlock) {
            try {
                ClientUtils.getBlockRenderer().renderSingleBlock(boundState, poseStack, bufferSource, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                ERRORED_BLOCK_STATES.add(boundState);
                Entangled.LOGGER.error("Encountered an exception whilst rendering block '" + boundState + "'! Please report to Entangled!", (Throwable)e);
            }
        }
        poseStack.popPose();
    }
}

