/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.entangled.EntangledBlockEntity;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;

public class TheOneProbePlugin {
    public static void interModEnqueue(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new ProbeInfoProvider());
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            return null;
        }

        public ResourceLocation getID() {
            return new ResourceLocation("entangled", "entangled_block");
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level world, BlockState state, IProbeHitData probeHitData) {
            BlockEntity tile = world.getBlockEntity(probeHitData.getPos());
            if (tile instanceof EntangledBlockEntity) {
                if (((EntangledBlockEntity)tile).isBound()) {
                    BlockState boundBlockState = ((EntangledBlockEntity)tile).getBoundBlockState();
                    MutableComponent boundBlock = TextComponents.string((String)TextStyleClass.HIGHLIGHTED.toString()).append(boundBlockState == null ? TextComponents.string((String)"Block").get() : TextComponents.blockState((BlockState)boundBlockState).get()).append(TextComponents.string((String)TextStyleClass.INFO.toString()).get()).get();
                    BlockPos boundPos = ((EntangledBlockEntity)tile).getBoundBlockPos();
                    String x = TextStyleClass.HIGHLIGHTED.toString() + boundPos.getX() + TextStyleClass.INFO;
                    String y = TextStyleClass.HIGHLIGHTED.toString() + boundPos.getY() + TextStyleClass.INFO;
                    String z = TextStyleClass.HIGHLIGHTED.toString() + boundPos.getZ() + TextStyleClass.INFO;
                    if (((EntangledBlockEntity)tile).getBoundDimensionIdentifier() == world.dimension()) {
                        probeInfo.vertical().text((Component)TextComponents.translation((String)"entangled.waila.bound_same_dimension", (Object[])new Object[]{boundBlock, x, y, z}).get());
                    } else {
                        String dimension = TextStyleClass.HIGHLIGHTED + TextComponents.dimension(((EntangledBlockEntity)tile).getBoundDimensionIdentifier()).format() + TextStyleClass.INFO;
                        probeInfo.vertical().text((Component)TextComponents.translation((String)"entangled.waila.bound_other_dimension", (Object[])new Object[]{boundBlock, x, y, z, dimension}).get());
                    }
                    if (!((EntangledBlockEntity)tile).isBoundAndValid()) {
                        probeInfo.text(TextStyleClass.WARNING + TextComponents.translation((String)"entangled.waila.invalid_block", (Object[])new Object[]{boundBlock}).color(ChatFormatting.RED).format());
                    }
                } else {
                    probeInfo.text((Component)TextComponents.translation((String)"entangled.waila.unbound").get());
                }
            }
        }
    }
}

