/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class ClearItemTask
extends TimerTask {
    public static ClearItemTask INSTANCE;
    int maxItems;
    List<Integer> list = new ArrayList<Integer>();
    Timer timer;
    public int lastCount;

    public static void start() {
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    public static void restart() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    private void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.list.clear();
        this.maxItems = 5000;
    }

    public void loadConfigsAndStart() {
        if (ClearItemTask.INSTANCE.timer != null) {
            ClearItemTask.INSTANCE.timer.cancel();
        }
        ClearItemTask.INSTANCE.timer = new Timer("CU Clear Item Task", true);
        this.maxItems = CrashUtils.SERVER_CONFIG.getMaximum();
        this.list = CrashUtils.SERVER_CONFIG.getWarnings();
        this.list.sort(Comparator.comparing(Integer::intValue));
        int time = CrashUtils.SERVER_CONFIG.getTimer() * 60 * 1000;
        if (time == 0) {
            time = 10000;
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            this.timer.scheduleAtFixedRate((TimerTask)this, time, (long)time);
        }
    }

    @Override
    public void run() {
        CrashUtils.runNextTick(this::runClear);
    }

    private void runClear(final ServerLevel world) {
        ArrayList entityList = new ArrayList();
        world.getEntities().getAll().forEach(x -> {
            if (x.getType().equals(EntityType.ITEM)) {
                entityList.add(x);
            }
        });
        this.lastCount = entityList.size();
        if (this.lastCount < this.maxItems) {
            return;
        }
        String text = CrashUtils.SERVER_CONFIG.getWarningText();
        int last = this.list.get(this.list.size() - 1);
        for (Integer integer : this.list) {
            if (integer.equals(last)) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        CrashUtils.runNextTick(world -> {
                            ArrayList entityList = new ArrayList();
                            world.getEntities().getAll().forEach(x -> {
                                if (x.getType().equals(EntityType.ITEM)) {
                                    entityList.add(x);
                                }
                            });
                            int size = entityList.size();
                            if (size > ClearItemTask.this.maxItems) {
                                entityList.forEach(entity -> entity.remove(Entity.RemovalReason.DISCARDED));
                                world.getServer().getPlayerList().broadcastSystemMessage((Component)CommandUtils.CreateTextComponent(size + " Items cleared"), false);
                            } else {
                                world.getServer().getPlayerList().broadcastSystemMessage((Component)CommandUtils.CreateTextComponent("Item Clear prevented. Only " + size + " items on the ground"), false);
                            }
                        });
                    }
                }, (long)integer.intValue() * 1000L);
            }
            String intText = text.replaceFirst("%", integer.toString());
            MutableComponent message = CommandUtils.CreateTextComponent("[=== ").append((Component)CommandUtils.CreateTextComponent(intText).withStyle(ChatFormatting.RED)).append((Component)CommandUtils.CreateTextComponent(" ===]"));
            new Timer().schedule(new TimerTask((Component)message){
                final /* synthetic */ Component val$message;
                {
                    this.val$message = component;
                }

                @Override
                public void run() {
                    world.getServer().getPlayerList().broadcastSystemMessage(this.val$message, false);
                }
            }, (long)(last - integer) * 1000L);
        }
        if (!CrashUtils.SERVER_CONFIG.getTitle()) {
            return;
        }
        try {
            if (world.getServer().getPlayerList().getPlayers().size() == 0) {
                return;
            }
            world.getServer().getCommands().getDispatcher().execute("title @a title {\"text\":\"" + CrashUtils.SERVER_CONFIG.getTitleText() + "\",\"color\":\"dark_red\"}", (Object)world.getServer().createCommandSourceStack());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }
}

