/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.InventoryCommands;

import com.darkere.crashutils.CommandUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class InventoryOpenEnderChestCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"enderchest").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes(ctx -> InventoryOpenEnderChestCommand.openInventory(StringArgumentType.getString((CommandContext)ctx, (String)"player"), (CommandContext<CommandSourceStack>)ctx)));
    }

    private static int openInventory(String playerName, CommandContext<CommandSourceStack> ctx) {
        if (!(((CommandSourceStack)ctx.getSource()).getEntity() instanceof ServerPlayer)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)CommandUtils.CreateTextComponent("You need to be a player to use this command, consider using \"cu inventory read\" instead"));
            return 0;
        }
        ServerPlayer sourcePlayer = (ServerPlayer)((CommandSourceStack)ctx.getSource()).getEntity();
        ServerPlayer otherPlayer = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (otherPlayer == null) {
            MinecraftServer server = sourcePlayer.getServer();
            Optional profile = server.getProfileCache().get(playerName);
            if (profile.isEmpty()) {
                CommandUtils.sendMessageToPlayer((Player)sourcePlayer, "Cannot find Player");
                return 0;
            }
            otherPlayer = new FakePlayer(Objects.requireNonNull(server.getLevel(Level.OVERWORLD)), (GameProfile)profile.get());
            CompoundTag nbt = server.playerDataStorage.load((Player)otherPlayer);
            if (nbt == null) {
                CommandUtils.sendMessageToPlayer((Player)sourcePlayer, "Cannot load playerData");
                return 0;
            }
            otherPlayer.load(nbt);
        }
        ServerPlayer finalOtherPlayer = otherPlayer;
        sourcePlayer.openMenu(new MenuProvider(){
            final /* synthetic */ Player val$finalOtherPlayer;
            final /* synthetic */ ServerPlayer val$sourcePlayer;
            final /* synthetic */ CommandContext val$ctx;
            {
                this.val$finalOtherPlayer = player;
                this.val$sourcePlayer = serverPlayer;
                this.val$ctx = commandContext;
            }

            public Component getDisplayName() {
                return this.val$finalOtherPlayer.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                return new ChestMenu(MenuType.GENERIC_9x3, id, this.val$sourcePlayer.getInventory(), (Container)this.val$finalOtherPlayer.getEnderChestInventory(), 3){

                    public void removed(Player p_75134_1_) {
                        super.removed(p_75134_1_);
                        ((CommandSourceStack)val$ctx.getSource()).getServer().playerDataStorage.save(val$finalOtherPlayer);
                    }

                    public boolean stillValid(Player p_75145_1_) {
                        return true;
                    }
                };
            }
        });
        return 1;
    }
}

