/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.LocationData;
import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class EntityData
extends LocationData {
    public EntityData() {
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            this.map.put(((ResourceKey)entry.getKey()).location(), new ArrayList());
        }
    }

    public EntityData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public void createLists(List<ServerLevel> worlds) {
        ArrayList entities = new ArrayList();
        worlds.forEach(x -> x.getEntities().getAll().forEach(entities::add));
        for (Entity entity : entities) {
            ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            ((List)this.map.get(key)).add(WorldPos.getPosFromEntity(entity));
        }
        this.total = entities.size();
    }

    public void reply(ResourceLocation res, CommandSourceStack source) {
        if (res == null) {
            this.map.entrySet().stream().filter(x -> ((List)x.getValue()).size() != 0).sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(e -> CommandUtils.sendFindEMessage(source, (ResourceLocation)e.getKey(), ((List)e.getValue()).size()));
            CommandUtils.sendNormalMessage(source, this.total + " Entities", ChatFormatting.DARK_AQUA);
        } else {
            this.sendEntityChunkMapCommand(source, res);
        }
    }

    private void sendEntityChunkMapCommand(CommandSourceStack source, ResourceLocation res) {
        this.fillChunkMaps(res.toString());
        CommandUtils.sendNormalMessage(source, res.toString(), ChatFormatting.DARK_BLUE);
        this.chunkMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(List::size))).forEach(k -> CommandUtils.sendChunkEntityMessage(source, ((List)k.getValue()).size(), ((WorldPos)this.tpPos.get(k.getKey())).pos, ((WorldPos)this.tpPos.get(k.getKey())).type, true));
    }
}

