/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;

public class DeleteBlocks {
    static Set<BlockPos> toDelete = new HashSet<BlockPos>();

    @SubscribeEvent
    public void loadChunkData(ChunkDataEvent.Load event) {
        toDelete.forEach(x -> {
            if (this.isInChunk((BlockPos)x, event.getChunk())) {
                this.deleteBlock((BlockPos)x, event.getChunk());
            }
        });
    }

    public static void addBlockToRemove(BlockPos pos) {
        toDelete.add(pos);
    }

    private boolean isInChunk(BlockPos pos, ChunkAccess chunk) {
        return pos.getX() > chunk.getPos().getMinBlockX() && pos.getX() < chunk.getPos().getMaxBlockX() && pos.getZ() > chunk.getPos().getMinBlockZ() && pos.getZ() < chunk.getPos().getMaxBlockZ();
    }

    private void deleteBlock(BlockPos pos, ChunkAccess chunk) {
        LevelAccessor world = chunk.getWorldForge();
        if (world != null) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 1);
            chunk.removeBlockEntity(pos);
        }
    }
}

