/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.NetworkTools;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record LoadedChunkDataStateMessage(Map<String, Set<ChunkPos>> loadedChunkStateData) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "loadedchunkdatastatemessage");

    public static LoadedChunkDataStateMessage decode(FriendlyByteBuf buf) {
        return new LoadedChunkDataStateMessage(NetworkTools.readSChPMap(buf));
    }

    public static void handle(LoadedChunkDataStateMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> DataHolder.addStateData(data.loadedChunkStateData));
    }

    public void write(FriendlyByteBuf buf) {
        if (NetworkTools.returnOnNull(this.loadedChunkStateData)) {
            return;
        }
        NetworkTools.writeSChPMap(buf, this.loadedChunkStateData);
    }

    public ResourceLocation id() {
        return ID;
    }
}

