/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.NetworkTools;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record LoadedChunkDataTicketsMessage(Map<String, Set<ChunkPos>> data) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "loadedchunkdataticketsmessage");

    public static LoadedChunkDataTicketsMessage decode(FriendlyByteBuf buf) {
        return new LoadedChunkDataTicketsMessage(NetworkTools.readSChPMap(buf));
    }

    public static void handle(LoadedChunkDataTicketsMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> DataHolder.addTicketData(data.data));
    }

    public void write(FriendlyByteBuf buf) {
        NetworkTools.writeSChPMap(buf, this.data);
    }

    public ResourceLocation id() {
        return ID;
    }
}

