/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.EntityDataMessage;
import com.darkere.crashutils.Network.LoadedChunkDataStateMessage;
import com.darkere.crashutils.Network.LoadedChunkDataTicketsMessage;
import com.darkere.crashutils.Network.OpenEnderChestMessage;
import com.darkere.crashutils.Network.OpenPlayerInvMessage;
import com.darkere.crashutils.Network.PlayerDataMessage;
import com.darkere.crashutils.Network.PlayerInventoryRequestMessage;
import com.darkere.crashutils.Network.RemoveEntitiesMessage;
import com.darkere.crashutils.Network.RemoveEntityMessage;
import com.darkere.crashutils.Network.TeleportMessage;
import com.darkere.crashutils.Network.TeleportToPlayerMessage;
import com.darkere.crashutils.Network.TileEntityDataMessage;
import com.darkere.crashutils.Network.UpdateDataRequestMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class Network {
    private static final String NETWORK_VERSION = "2";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlerEvent Event2) {
        IPayloadRegistrar registrar = Event2.registrar("crashutilities").versioned(NETWORK_VERSION);
        registrar.play(UpdateDataRequestMessage.ID, UpdateDataRequestMessage::decode, UpdateDataRequestMessage::handle);
        registrar.play(EntityDataMessage.ID, EntityDataMessage::decode, EntityDataMessage::handle);
        registrar.play(TeleportMessage.ID, TeleportMessage::decode, TeleportMessage::handle);
        registrar.play(PlayerInventoryRequestMessage.ID, PlayerInventoryRequestMessage::decode, PlayerInventoryRequestMessage::handle);
        registrar.play(PlayerDataMessage.ID, PlayerDataMessage::decode, PlayerDataMessage::handle);
        registrar.play(OpenPlayerInvMessage.ID, OpenPlayerInvMessage::decode, OpenPlayerInvMessage::handle);
        registrar.play(TeleportToPlayerMessage.ID, TeleportToPlayerMessage::decode, TeleportToPlayerMessage::handle);
        registrar.play(RemoveEntitiesMessage.ID, RemoveEntitiesMessage::decode, RemoveEntitiesMessage::handle);
        registrar.play(RemoveEntityMessage.ID, RemoveEntityMessage::decode, RemoveEntityMessage::handle);
        registrar.play(OpenEnderChestMessage.ID, OpenEnderChestMessage::decode, OpenEnderChestMessage::handle);
        registrar.play(LoadedChunkDataStateMessage.ID, LoadedChunkDataStateMessage::decode, LoadedChunkDataStateMessage::handle);
        registrar.play(TileEntityDataMessage.ID, TileEntityDataMessage::decode, TileEntityDataMessage::handle);
        registrar.play(LoadedChunkDataTicketsMessage.ID, LoadedChunkDataTicketsMessage::decode, LoadedChunkDataTicketsMessage::handle);
    }

    public static void sendToPlayer(ServerPlayer player, CustomPacketPayload message) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{message});
    }

    public static void sendToServer(CustomPacketPayload message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{message});
    }
}

