/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CommandUtils;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record OpenEnderChestMessage(String playerName) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "openenderchestmessage");

    public static OpenEnderChestMessage decode(FriendlyByteBuf buf) {
        return new OpenEnderChestMessage(buf.readUtf(32000));
    }

    public static boolean handle(OpenEnderChestMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player().get();
            if (player == null || player.getServer() == null || !player.hasPermissions(2)) {
                return;
            }
            ServerPlayer otherPlayer = player.getServer().getPlayerList().getPlayerByName(data.playerName);
            if (otherPlayer == null) {
                Optional profile = player.getServer().getProfileCache().get(data.playerName);
                if (profile.isEmpty()) {
                    CommandUtils.sendMessageToPlayer((Player)player, "Cannot find Player");
                    return;
                }
                otherPlayer = new FakePlayer(player.getServer().getLevel(Level.OVERWORLD), (GameProfile)profile.get());
                CompoundTag nbt = player.getServer().playerDataStorage.load((Player)otherPlayer);
                if (nbt == null) {
                    CommandUtils.sendMessageToPlayer((Player)player, "Cannot load playerData");
                    return;
                }
                otherPlayer.load(nbt);
            }
            ServerPlayer finalOtherPlayer = otherPlayer;
            player.openMenu(new MenuProvider(){
                final /* synthetic */ Player val$finalOtherPlayer;
                final /* synthetic */ ServerPlayer val$player;
                {
                    this.val$finalOtherPlayer = player;
                    this.val$player = serverPlayer;
                }

                public Component getDisplayName() {
                    return this.val$finalOtherPlayer.getDisplayName();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int id, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                    return new ChestMenu(MenuType.GENERIC_9x3, id, this.val$player.getInventory(), (Container)this.val$finalOtherPlayer.getEnderChestInventory(), 3){

                        public void removed(Player p_75134_1_) {
                            super.removed(p_75134_1_);
                            val$player.getServer().playerDataStorage.save(val$finalOtherPlayer);
                        }

                        public boolean stillValid(Player p_75145_1_) {
                            return true;
                        }
                    };
                }
            });
        });
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.playerName);
    }

    public ResourceLocation id() {
        return ID;
    }
}

