/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.ClientEvents;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record OpenPlayerInvMessage(Map<String, Integer> slotAmounts, String otherPlayerName, int windowID) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "openplayerinvmessage");

    public static void encode(OpenPlayerInvMessage data, FriendlyByteBuf buf) {
    }

    public static OpenPlayerInvMessage decode(FriendlyByteBuf buf) {
        LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
        int id = buf.readInt();
        String name = buf.readUtf();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            curios.put(buf.readUtf(), buf.readInt());
        }
        return new OpenPlayerInvMessage(curios, name, id);
    }

    public static boolean handle(OpenPlayerInvMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ClientEvents.openContainerAndScreen(data.windowID, data.otherPlayerName, data.slotAmounts));
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.windowID);
        buf.writeUtf(this.otherPlayerName);
        buf.writeInt(this.slotAmounts.size());
        this.slotAmounts.forEach((s, i) -> {
            buf.writeUtf(s);
            buf.writeInt(i.intValue());
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

