/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.DataStructures.PlayerData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PlayerDataMessage(PlayerData data) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "playerdatamessage");

    public static PlayerDataMessage decode(FriendlyByteBuf buf) {
        ArrayList<String> names = new ArrayList<String>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            names.add(buf.readUtf());
        }
        return new PlayerDataMessage(new PlayerData(names));
    }

    public static boolean handle(PlayerDataMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> DataHolder.addPlayerData(data.data));
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        List<String> names = this.data.getPlayerNames(null);
        buf.writeInt(names.size());
        names.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeUtf(arg_0));
    }

    public ResourceLocation id() {
        return ID;
    }
}

