/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.OpenPlayerInvMessage;
import com.darkere.crashutils.Screens.PlayerInvContainer;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public record PlayerInventoryRequestMessage(String playerName) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "playerinventoryrequestmessage");

    public static PlayerInventoryRequestMessage decode(FriendlyByteBuf buf) {
        return new PlayerInventoryRequestMessage(buf.readUtf(buf.readInt()));
    }

    public static boolean handle(PlayerInventoryRequestMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player().get();
            MinecraftServer server = player.getServer();
            if (!player.hasPermissions(2)) {
                return;
            }
            ServerPlayer otherPlayer = player.getServer().getPlayerList().getPlayerByName(data.playerName);
            if (otherPlayer == null) {
                Optional profile = server.getProfileCache().get(data.playerName);
                if (profile.isEmpty()) {
                    CommandUtils.sendMessageToPlayer((Player)player, "Cannot find Player");
                    return;
                }
                otherPlayer = new FakePlayer(server.getLevel(Level.OVERWORLD), (GameProfile)profile.get());
                CompoundTag nbt = server.playerDataStorage.load((Player)otherPlayer);
                if (nbt == null) {
                    CommandUtils.sendMessageToPlayer((Player)player, "Cannot load playerData");
                    return;
                }
                otherPlayer.load(nbt);
            }
            LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
            if (CrashUtils.curiosLoaded) {
                ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)otherPlayer).get()).getCurios().forEach((s, handler) -> curios.put((String)s, handler.getSlots()));
            }
            player.doCloseContainer();
            player.nextContainerCounter();
            int id = player.containerCounter;
            Network.sendToPlayer(player, new OpenPlayerInvMessage(curios, data.playerName, id));
            player.containerMenu = new PlayerInvContainer((Player)player, (Player)otherPlayer, id, null, null, 0);
            player.initMenu(player.containerMenu);
        });
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.playerName.length());
        buf.writeUtf(this.playerName);
    }

    public ResourceLocation id() {
        return ID;
    }
}

