/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record RemoveEntityMessage(ResourceKey<Level> worldRegistryKey, UUID uuid, boolean tile, boolean force) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("crashutilities", "removeentitymessage");

    public static RemoveEntityMessage decode(FriendlyByteBuf buf) {
        return new RemoveEntityMessage(NetworkTools.readWorldKey(buf), buf.readUUID(), buf.readBoolean(), buf.readBoolean());
    }

    public static boolean handle(RemoveEntityMessage data, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player().get();
            if (!player.hasPermissions(2)) {
                return;
            }
            if (data.tile) {
                WorldUtils.removeTileEntity((Level)player.getServer().getLevel(data.worldRegistryKey), data.uuid, data.force);
            } else {
                WorldUtils.removeEntity((Level)player.getServer().getLevel(data.worldRegistryKey), data.uuid);
            }
        });
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        NetworkTools.writeWorldKey(this.worldRegistryKey, buf);
        buf.writeUUID(this.uuid);
        buf.writeBoolean(this.tile);
        buf.writeBoolean(this.force);
    }

    public ResourceLocation id() {
        return ID;
    }
}

