/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.TeleportMessage;
import com.darkere.crashutils.Screens.CUButton;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUTab;
import com.darkere.crashutils.Screens.DataListGUI;
import com.darkere.crashutils.Screens.MapGUI;
import com.darkere.crashutils.Screens.Types.DropDownType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class CUScreen
extends Screen {
    public static CUScreen stored;
    CUContentPane contentGUI;
    long doubleClickTimer;
    double oldClickX;
    double OldClickY;
    ResourceKey<Level> dim;
    int centerX;
    int centerY;
    int activeTab = 0;
    int tabs = 2;
    private static final ResourceLocation WINDOW;
    public List<CUDropDown> topDropDowns = new ArrayList<CUDropDown>();
    CUButton updateButton;
    CUButton backButton;
    boolean dragging;
    BlockPos initial;
    static boolean keep;

    public CUScreen(ResourceKey<Level> worldKey, BlockPos position) {
        super((Component)CommandUtils.CreateTextComponent("CUScreen"));
        this.dim = worldKey;
        this.initial = position;
    }

    protected void init() {
        super.init();
        this.centerY = this.height / 2;
        this.centerX = this.width / 2;
        if (!keep) {
            this.contentGUI = new MapGUI(this, this.dim, this.initial);
            DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
        }
        ArrayList<String> updateButtonText = new ArrayList<String>();
        updateButtonText.add("Requesting data every " + this.contentGUI.updateSpeed + " seconds");
        updateButtonText.add("Scroll to change update Speed");
        this.updateButton = new CUButton(this.centerX + 174, this.centerY - 103, 20, 10, (Component)CommandUtils.CreateTextComponent(String.valueOf(this.contentGUI.updateSpeed)), x -> {
            this.contentGUI.shouldUpdate = !this.contentGUI.shouldUpdate;
            this.contentGUI.setUpdateSpeed();
        }, updateButtonText);
        this.addWidget((GuiEventListener)this.updateButton);
        this.backButton = new CUButton(this.centerX + 145, this.centerY - 103, 20, 10, (Component)CommandUtils.CreateTextComponent("<-"), button -> {
            if (this.contentGUI instanceof DataListGUI) {
                ((DataListGUI)this.contentGUI).loader.goBack();
            } else if (this.contentGUI instanceof MapGUI) {
                ((MapGUI)this.contentGUI).goTo(((MapGUI)this.contentGUI).initial);
            }
        }, this.contentGUI instanceof MapGUI ? "Return to player" : "Go Back"){

            public boolean isActive() {
                if (CUScreen.this.contentGUI instanceof DataListGUI) {
                    return ((DataListGUI)CUScreen.this.contentGUI).loader.history.size() > 1;
                }
                return super.isActive();
            }
        };
        this.addWidget((GuiEventListener)this.backButton);
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        int i = this.centerX - 200;
        int j = this.centerY - 108;
        guiGraphics.blit(WINDOW, i, j, 0.0f, 0.0f, 400, 216, 512, 512);
        this.renderTabs(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.render(guiGraphics, mx, my, partialTicks);
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        guiGraphics.fill(this.centerX + 173, this.centerY - 105, this.centerX + 195, this.centerY - 93, this.contentGUI.shouldUpdate ? -11406014 : -703934);
        this.updateButton.setX(this.centerX + 174);
        this.updateButton.setY(this.centerY - 104);
        this.backButton.setX(this.centerX + 145);
        this.backButton.setY(this.centerY - 103);
        this.updateButton.render(guiGraphics, mx, my, partialTicks);
        this.backButton.render(guiGraphics, mx, my, partialTicks);
        this.contentGUI.render(guiGraphics, this.centerX, this.centerY, mx, my, partialTicks);
        this.topDropDowns.forEach(x -> x.render(guiGraphics, this.centerX, this.centerY));
        this.renderToolTips(guiGraphics, mx, my);
    }

    private void renderToolTips(GuiGraphics guiGraphics, int mx, int my) {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY) && this.contentGUI instanceof MapGUI) {
            MapGUI gui = (MapGUI)this.contentGUI;
            ChunkPos chunkPos = gui.getChunkFor(mx, my);
            tooltips.add(CommandUtils.CreateTextComponent("Chunk: X: " + chunkPos.x + " Z: " + chunkPos.z));
            String loc = gui.getLocFor(mx, my);
            tooltips.add(CommandUtils.CreateTextComponent("State: " + gui.getNameForLocationType(loc)));
            StringBuilder builder = new StringBuilder();
            switch (gui.type) {
                case TICKET: 
                case LOCATIONTYPE: {
                    builder.append("Tickets: ");
                    String tickets = gui.getTicketsFor(mx, my);
                    builder.append(tickets == null ? "None" : tickets);
                    break;
                }
                case ENTITIES: {
                    builder.append("Entities: ");
                    String entities = gui.getEntityCountFor(mx, my);
                    builder.append(entities == null ? "None" : entities);
                    break;
                }
                case TILEENTITIES: {
                    builder.append("Tileentities: ");
                    String tileEntities = gui.getTileEntityCountFor(mx, my);
                    builder.append(tileEntities == null ? "None" : tileEntities);
                }
            }
            tooltips.add(CommandUtils.CreateTextComponent(builder.toString()));
            tooltips.add(CommandUtils.CreateTextComponent("(Double click to teleport)"));
        }
        if (!tooltips.isEmpty()) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltips, Optional.empty(), mx, my);
        }
    }

    private void renderTabs(GuiGraphics guiGraphics) {
        int x = this.centerX - 200;
        int y = this.centerY - 108 - 22;
        float iconScale = 3.75f;
        ArrayList<CUTab> tabIcons = new ArrayList<CUTab>();
        tabIcons.add(CUTab.MAPTABICON);
        tabIcons.add(CUTab.LISTTABICON);
        tabIcons.add(CUTab.INVSEETABICON);
        for (int i = 0; i < this.tabs; ++i) {
            if (i == 0) {
                if (i == this.activeTab) {
                    CUTab.ATL.drawTab(guiGraphics, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                    continue;
                }
                CUTab.ITL.drawTab(guiGraphics, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            if (i == this.activeTab) {
                CUTab.ATC.drawTab(guiGraphics, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            CUTab.ITC.drawTab(guiGraphics, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        super.removed();
        DataHolder.cancelTimer();
        DataHolder.stopListening();
        stored = this;
    }

    public boolean mouseDragged(double XStart, double YStart, int Button2, double XDif, double YDif) {
        if (this.dragging) {
            this.contentGUI.addOffset(-XDif, -YDif);
            return true;
        }
        return super.mouseDragged(XStart, YStart, Button2, XDif, YDif);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (p_mouseReleased_5_ == 0) {
            this.dragging = false;
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseClicked(double mx, double my, int mouseButton) {
        for (CUDropDown cUDropDown : this.topDropDowns) {
            if (!cUDropDown.checkClick((int)mx, (int)my)) continue;
            return true;
        }
        if (this.contentGUI.mouseClickedOutside(mx, my, this.centerX, this.centerY, mouseButton)) {
            return true;
        }
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
            this.dragging = true;
            if (this.contentGUI.mouseClicked(mx, my, mouseButton)) {
                return true;
            }
        }
        if (my > (double)(this.centerY - 126) && my < (double)(this.centerY - 107)) {
            return this.clickedTabArea(mx, my, mouseButton);
        }
        if (Instant.now().getEpochSecond() - this.doubleClickTimer < 1L) {
            if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
                if (Math.sqrt((this.oldClickX - mx) * (this.oldClickX - mx) + (this.OldClickY - my) * (this.OldClickY - my)) > 5.0) {
                    return super.mouseClicked(mx, my, mouseButton);
                }
                CUContentPane cUContentPane = this.contentGUI;
                if (cUContentPane instanceof MapGUI) {
                    MapGUI gui = (MapGUI)cUContentPane;
                    BlockPos blockPos = gui.getChunkFor((int)mx, (int)my).getWorldPosition();
                    Network.sendToServer(new TeleportMessage(this.dim, this.dim, blockPos));
                    return true;
                }
            }
        } else {
            this.doubleClickTimer = Instant.now().getEpochSecond();
            this.oldClickX = mx;
            this.OldClickY = my;
        }
        return super.mouseClicked(mx, my, mouseButton);
    }

    private boolean clickedTabArea(double mx, double my, int mouseButton) {
        int x = (int)mx - (this.centerX - 198);
        int tab = x / 27;
        if (tab >= this.tabs) {
            return false;
        }
        this.activeTab = tab;
        this.switchTabs();
        return true;
    }

    private void switchTabs() {
        this.topDropDowns.clear();
        switch (this.activeTab) {
            case 0: {
                this.contentGUI = new MapGUI(this, this.dim, this.initial);
                keep = false;
                break;
            }
            case 1: {
                this.contentGUI = new DataListGUI(this, this.dim);
                keep = true;
            }
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.updateButton.isMouseOver(pMouseX, pMouseY)) {
            if (pScrollY > 0.0 && this.contentGUI.updateSpeed < 5) {
                ++this.contentGUI.updateSpeed;
            } else if (pScrollY > 0.0 && this.contentGUI.updateSpeed < 60) {
                this.contentGUI.updateSpeed += 5;
            } else if (pScrollY < 0.0 && this.contentGUI.updateSpeed > 5) {
                this.contentGUI.updateSpeed -= 5;
            } else if (pScrollY < 0.0 && this.contentGUI.updateSpeed <= 5 && this.contentGUI.updateSpeed > 1) {
                --this.contentGUI.updateSpeed;
            }
            this.updateButton.setMessage((Component)CommandUtils.CreateTextComponent(String.valueOf(this.contentGUI.updateSpeed)));
            this.contentGUI.setUpdateSpeed();
            return true;
        }
        if (this.contentGUI.isMouseOver(pMouseX, pMouseY, this.centerX, this.centerY)) {
            for (CUDropDown dropDown : this.topDropDowns) {
                if (!dropDown.scroll(pMouseX, pMouseY, pScrollY)) continue;
                return true;
            }
            this.contentGUI.scroll(pMouseX, pMouseY, pScrollY, this.centerX, this.centerY);
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.contentGUI.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.contentGUI.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public void updateSelection(DropDownType ddtype, String s) {
        this.contentGUI.updateSelection(ddtype, s);
    }

    public static CUScreen openCUScreen(ResourceKey<Level> world, BlockPos pos) {
        if (stored == null || !keep || !world.equals(CUScreen.stored.dim)) {
            keep = false;
            stored = new CUScreen(world, pos);
            return stored;
        }
        CUContentPane cUContentPane = CUScreen.stored.contentGUI;
        if (cUContentPane instanceof DataListGUI) {
            DataListGUI gui = (DataListGUI)cUContentPane;
            if (!gui.loader.history.isEmpty()) {
                gui.loader.history.get(gui.loader.history.size() - 1).accept(false);
                gui.loader.history.remove(gui.loader.history.size() - 1);
            }
        }
        DataHolder.notifyListener();
        CUScreen.stored.contentGUI.setUpdateSpeed();
        return stored;
    }

    static {
        WINDOW = new ResourceLocation("crashutilities", "textures/gui/cuscreen.png");
        keep = false;
    }
}

