/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class FillMany {
    public static void drawStrings(GuiGraphics guiGraphics, Font renderer, List<Text> texts) {
        for (Text text : texts) {
            guiGraphics.drawString(renderer, text.text, text.x, text.y, text.color, false);
        }
    }

    public static void fillMany(Matrix4f matrix, List<ColoredRectangle> rects) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (ColoredRectangle rect : rects) {
            FillMany.addRectangle(bufferbuilder, matrix, rect.x0, rect.y0, rect.x1, rect.y1, rect.color);
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
    }

    private static void addRectangle(BufferBuilder bufferbuilder, Matrix4f matrix, int x0, int y0, int x1, int y1, int color) {
        if (x0 < x1) {
            int i = x0;
            x0 = x1;
            x1 = i;
        }
        if (y0 < y1) {
            int j = y0;
            y0 = y1;
            y1 = j;
        }
        float ca = (float)(color >> 24 & 0xFF) / 255.0f;
        float cr = (float)(color >> 16 & 0xFF) / 255.0f;
        float cg = (float)(color >> 8 & 0xFF) / 255.0f;
        float cb = (float)(color & 0xFF) / 255.0f;
        bufferbuilder.vertex(matrix, (float)x0, (float)y1, 0.0f).color(cr, cg, cb, ca).endVertex();
        bufferbuilder.vertex(matrix, (float)x1, (float)y1, 0.0f).color(cr, cg, cb, ca).endVertex();
        bufferbuilder.vertex(matrix, (float)x1, (float)y0, 0.0f).color(cr, cg, cb, ca).endVertex();
        bufferbuilder.vertex(matrix, (float)x0, (float)y0, 0.0f).color(cr, cg, cb, ca).endVertex();
    }

    public static final class Text {
        public final int x;
        public final int y;
        public final String text;
        int color;

        public Text(int x, int y, String text, int color) {
            this.x = x;
            this.y = y;
            this.text = text;
            this.color = color;
        }
    }

    public static final class ColoredRectangle {
        public final int x0;
        public final int y0;
        public final int x1;
        public final int y1;
        public final int color;

        public ColoredRectangle(int x0, int y0, int x1, int y1, int color) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.color = color;
        }
    }
}

