/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.CustomFakePlayer;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.RemoveEntitiesMessage;
import com.darkere.crashutils.Network.RemoveEntityMessage;
import com.darkere.crashutils.Network.TeleportMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.ITeleporter;

public class WorldUtils {
    public static List<ServerLevel> getWorldsFromDimensionArgument(CommandContext<CommandSourceStack> context) {
        ServerLevel world = null;
        try {
            world = DimensionArgument.getDimension(context, (String)"dim");
        }
        catch (CommandSyntaxException | IllegalArgumentException throwable) {
            // empty catch block
        }
        ArrayList<ServerLevel> worlds = new ArrayList<ServerLevel>();
        if (world == null) {
            ((CommandSourceStack)context.getSource()).getServer().getAllLevels().forEach(worlds::add);
        } else {
            worlds.add(world);
        }
        return worlds;
    }

    public static void teleportPlayer(Player player, Level startWorld, Level destWorld, BlockPos newPos) {
        if (player.getCommandSenderWorld().isClientSide()) {
            Network.sendToServer(new TeleportMessage((ResourceKey<Level>)startWorld.dimension(), (ResourceKey<Level>)destWorld.dimension(), newPos));
        }
        if (newPos.getY() == 0) {
            LevelChunk chunk = destWorld.getChunkAt(newPos);
            int y = chunk.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, newPos.getX(), newPos.getZ());
            newPos = new BlockPos(newPos.getX(), y, newPos.getZ());
        }
        if (startWorld != destWorld) {
            final BlockPos finalNewPos = newPos;
            player.changeDimension((ServerLevel)destWorld, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity entity1 = repositionEntity.apply(false);
                    entity1.teleportTo((double)finalNewPos.getX(), (double)(finalNewPos.getY() + 1), (double)finalNewPos.getZ());
                    return entity1;
                }
            });
        } else {
            player.teleportTo((double)newPos.getX(), (double)(newPos.getY() + 1), (double)newPos.getZ());
        }
    }

    public static boolean applyToPlayer(String playerName, MinecraftServer server, Consumer<ServerPlayer> consumer) {
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            Optional profile = server.getProfileCache().get(playerName);
            if (profile.isEmpty()) {
                return false;
            }
            CustomFakePlayer fakePlayer = new CustomFakePlayer(server.getLevel(Level.OVERWORLD), (GameProfile)profile.get());
            CompoundTag nbt = server.playerDataStorage.load((Player)fakePlayer);
            if (nbt == null) {
                return false;
            }
            fakePlayer.load(nbt);
            consumer.accept((ServerPlayer)fakePlayer);
            server.playerDataStorage.save((Player)fakePlayer);
        } else {
            consumer.accept(player);
        }
        return true;
    }

    public static BlockPos getChunkCenter(ChunkPos pos) {
        int x = pos.getMinBlockX() + 8;
        int z = pos.getMinBlockZ() + 8;
        return new BlockPos(x, 0, z);
    }

    public static void removeEntity(Level world, UUID id) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.dimension(), id, false, false));
            return;
        }
        Entity e = ((ServerLevel)world).getEntity(id);
        if (e == null) {
            return;
        }
        e.remove(Entity.RemovalReason.DISCARDED);
    }

    public static void removeEntityType(Level world, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, rl)) {
            return;
        }
        ArrayList runnables = new ArrayList();
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.dimension(), rl, null, false, force));
            return;
        }
        ((ServerLevel)world).getEntities().getAll().forEach(entity -> {
            ResourceLocation rl2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (!Objects.equals(rl2, rl)) {
                return;
            }
            runnables.add(() -> entity.remove(Entity.RemovalReason.DISCARDED));
        });
        runnables.forEach(Runnable::run);
    }

    public static void removeEntitiesInChunk(Level world, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(world, pos, rl)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)world.dimension(), rl, pos, false, force));
            return;
        }
        Vec3 start = new Vec3((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ());
        Vec3 end = new Vec3((double)pos.getMaxBlockX(), 255.0, (double)pos.getMaxBlockZ());
        world.getEntities((Entity)null, new AABB(start, end), entity -> Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), rl)).forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
    }

    public static void removeTileEntity(Level world, UUID id, boolean force) {
        if (NetworkTools.returnOnNull(world, id)) {
            return;
        }
        if (world.isClientSide) {
            Network.sendToServer(new RemoveEntityMessage((ResourceKey<Level>)world.dimension(), id, true, force));
            return;
        }
        CrashUtils.runNextTick(wld -> {
            if (force) {
                world.removeBlockEntity(TileEntityData.TEID.get((Object)id).pos);
                world.removeBlock(TileEntityData.TEID.get((Object)id).pos, false);
            } else {
                world.removeBlockEntity(TileEntityData.TEID.get((Object)id).pos);
            }
        });
    }

    public static void removeTileEntityType(Level level, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(level, rl)) {
            return;
        }
        if (level.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)level.dimension(), rl, null, true, force));
            return;
        }
        for (ChunkHolder chunk : ((ServerLevel)level).getChunkSource().chunkMap.getChunks()) {
            if (!chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
            chunk.getFullChunk().getBlockEntities().forEach((pos, e) -> {
                if (BlockEntityType.getKey((BlockEntityType)e.getType()) == rl) {
                    CrashUtils.runNextTick(wld -> {
                        if (force) {
                            level.removeBlockEntity(e.getBlockPos());
                            level.removeBlock(e.getBlockPos(), false);
                        } else {
                            level.removeBlockEntity(e.getBlockPos());
                        }
                    });
                }
            });
        }
    }

    public static void removeTileEntitiesInChunk(Level level, ChunkPos pos, ResourceLocation rl, boolean force) {
        if (NetworkTools.returnOnNull(level, pos, rl)) {
            return;
        }
        if (level.isClientSide) {
            Network.sendToServer(new RemoveEntitiesMessage((ResourceKey<Level>)level.dimension(), rl, pos, true, force));
            return;
        }
        Vec3 start = new Vec3((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ());
        Vec3 end = new Vec3((double)pos.getMaxBlockX(), 255.0, (double)pos.getMaxBlockZ());
        level.blockEntityTickers.stream().filter(te -> Objects.equals(te.getType(), rl.toString()) && new AABB(start, end).contains(Vec3.atCenterOf((Vec3i)te.getPos()))).forEach(te -> CrashUtils.runNextTick(wld -> {
            if (force) {
                level.removeBlockEntity(te.getPos());
                level.removeBlock(te.getPos(), false);
            } else {
                level.removeBlockEntity(te.getPos());
            }
        }));
    }
}

