/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.morebeautifulbuttons.datagen.data;

import com.kreezcraft.morebeautifulbuttons.registration.ModRegistry;
import com.kreezcraft.morebeautifulbuttons.registration.RegistryObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class ButtonLootProvider
extends LootTableProvider {
    public ButtonLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ButtonBlockTables::new, LootContextParamSets.BLOCK)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        map.forEach((name, table) -> table.validate(validationContext));
    }

    public static class ButtonBlockTables
    extends BlockLootSubProvider {
        protected ButtonBlockTables() {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags());
        }

        protected void generate() {
            for (RegistryObject<Block> registryObject : ModRegistry.BLOCKS.getEntries()) {
                this.dropSelf(registryObject.get());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModRegistry.BLOCKS.getEntries().stream().map(entry -> (Block)entry.get())::iterator;
        }
    }
}

