/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client;

import com.legacy.mining_helmet.MiningHelmetConfig;
import com.legacy.mining_helmet.MiningHelmetMod;
import com.legacy.mining_helmet.MiningHelmetRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightingManager {
    private static final Minecraft MC = Minecraft.getInstance();
    public static final Map<BlockPos, LightData> SOURCES = new ConcurrentHashMap<BlockPos, LightData>();

    public static void tick() {
        if (MiningHelmetMod.lucentPresent()) {
            return;
        }
        if (DynamicLightingManager.MC.player != null && DynamicLightingManager.MC.level != null && DynamicLightingManager.MC.player.tickCount % MiningHelmetConfig.lightRefreshRate() == 0) {
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
            });
            DynamicLightingManager.MC.level.getEntitiesOfClass(LivingEntity.class, DynamicLightingManager.MC.player.getBoundingBox().inflate((double)MiningHelmetConfig.maxVisibleDistance()), DynamicLightingManager::shouldGlow).forEach(e -> SOURCES.put(e.blockPosition().above((int)e.getEyeHeight()), new LightData()));
            if (!SOURCES.isEmpty()) {
                SOURCES.forEach((blockPos, data) -> DynamicLightingManager.MC.level.getChunkSource().getLightEngine().checkBlock(blockPos));
                SOURCES.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldStay);
            }
        }
    }

    public static boolean shouldGlow(LivingEntity entity) {
        if (MiningHelmetMod.lucentPresent() || entity.isSpectator()) {
            return false;
        }
        if (entity.getItemBySlot(EquipmentSlot.HEAD).getItem() == MiningHelmetRegistry.MINING_HELMET.get()) {
            boolean visible = MiningHelmetConfig.seeThroughWalls();
            if (!visible) {
                boolean bl = visible = DynamicLightingManager.MC.player.level().clip(new ClipContext(DynamicLightingManager.MC.player.position(), entity.getEyePosition(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)entity)).getType() == HitResult.Type.MISS;
                if (!visible && DynamicLightingManager.MC.player.distanceTo((Entity)entity) < 24.0f) {
                    visible = true;
                }
            }
            return visible;
        }
        return false;
    }

    public static void cleanUp() {
        if (MiningHelmetMod.lucentPresent()) {
            return;
        }
        if (SOURCES.size() > 0 && DynamicLightingManager.MC.level != null) {
            MiningHelmetMod.LOGGER.info(String.format("Cleaning up light data for %s light sources", SOURCES.size()));
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
                DynamicLightingManager.MC.level.getChunkSource().getLightEngine().checkBlock(blockPos);
            });
            SOURCES.clear();
        }
    }

    public static class LightData {
        public boolean shouldStay = true;
    }
}

