/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client.model;

import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class MiningHelmetModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public ModelPart base;
    public ModelPart lid;
    public ModelPart light;

    public MiningHelmetModel(ModelPart model) {
        super(model);
        this.lid = model.getChild("lid");
        this.base = model.getChild("base");
        this.light = model.getChild("light");
    }

    public static LayerDefinition createHelmetLayer(CubeDeformation size, boolean coverFace) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)size, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        CubeDeformation scale = CubeDeformation.NONE;
        float offsetAmount = !coverFace ? 2.0f : 1.0f;
        root.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, -4.0f - offsetAmount, -6.0f, 12.0f, 2.0f, 12.0f, scale), PartPose.ZERO);
        root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f - offsetAmount, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.ZERO);
        root.addOrReplaceChild("light", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -10.0f - offsetAmount, -7.0f, 6.0f, 6.0f, 3.0f, scale), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        float offset = this.head.y;
        this.lid.copyFrom(this.head);
        this.base.copyFrom(this.head);
        this.light.copyFrom(this.head);
        this.lid.y = offset;
        this.base.y = offset;
        this.light.y = offset;
        return List.of(this.base, this.lid, this.light);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of();
    }
}

