/*
 * Decompiled with CFR 0.152.
 */
package mars.laserbridges.com.laserbridges;

import mars.laserbridges.com.laserbridges.LaserBlock;
import mars.laserbridges.com.laserbridges.LaserSourceBlock;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="laserbridges")
public class LaserBridges {
    public static final String MODID = "laserbridges";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"laserbridges");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"laserbridges");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"laserbridges");
    public static final DeferredBlock<Block> EXAMPLE_BLOCK = BLOCKS.registerSimpleBlock("example_block", BlockBehaviour.Properties.of().mapColor(MapColor.STONE));
    public static final DeferredItem<BlockItem> EXAMPLE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("example_block", EXAMPLE_BLOCK);
    public static final DeferredBlock<Block> LASER_SOURCE_BLOCK = BLOCKS.register("laser_source_block", () -> new LaserSourceBlock(BlockBehaviour.Properties.of().strength(0.7f).noOcclusion()));
    public static final DeferredItem<BlockItem> LASER_SOURCE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("laser_source_block", LASER_SOURCE_BLOCK);
    public static final DeferredBlock<Block> LASER_BLOCK = BLOCKS.register("laser_block_powered", () -> new LaserBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).noOcclusion()));
    public static final DeferredHolder<SoundEvent, SoundEvent> ON = LaserBridges.registerSoundEvent("on");
    public static final DeferredHolder<SoundEvent, SoundEvent> OFF = LaserBridges.registerSoundEvent("off");

    public static DeferredHolder<SoundEvent, SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createFixedRangeEvent((ResourceLocation)new ResourceLocation(MODID, name), (float)75.0f));
    }

    public LaserBridges(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::clientSetup);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept(LASER_SOURCE_BLOCK_ITEM);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_SOURCE_BLOCK.get()), (RenderType)RenderType.translucent());
    }
}

