/*
 * Decompiled with CFR 0.152.
 */
package mars.laserbridges.com.laserbridges;

import com.mojang.serialization.MapCodec;
import mars.laserbridges.com.laserbridges.LaserBridges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaserSourceBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    protected static final VoxelShape CEILING_X_SHAPE = Block.box((double)6.5, (double)14.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.box((double)0.0, (double)14.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final VoxelShape CEILING_X_POWERED_SHAPE = Shapes.or((VoxelShape)CEILING_X_SHAPE, (VoxelShape)Block.box((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)14.0, (double)16.0));
    protected static final VoxelShape CEILING_Z_POWERED_SHAPE = Shapes.or((VoxelShape)CEILING_Z_SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)14.0, (double)8.5));
    protected static final VoxelShape FLOOR_X_SHAPE = Block.box((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)2.0, (double)16.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)2.0, (double)9.5);
    protected static final VoxelShape FLOOR_X_POWERED_SHAPE = Shapes.or((VoxelShape)FLOOR_X_SHAPE, (VoxelShape)Block.box((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0));
    protected static final VoxelShape FLOOR_Z_POWERED_SHAPE = Shapes.or((VoxelShape)FLOOR_Z_SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5));
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    protected static final VoxelShape NORTH_POWERED_SHAPE = Shapes.or((VoxelShape)NORTH_SHAPE, (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));
    protected static final VoxelShape SOUTH_POWERED_SHAPE = Shapes.or((VoxelShape)SOUTH_SHAPE, (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.16, (double)10.0, (double)16.0));
    protected static final VoxelShape WEST_POWERED_SHAPE = Shapes.or((VoxelShape)WEST_SHAPE, (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));
    protected static final VoxelShape EAST_POWERED_SHAPE = Shapes.or((VoxelShape)EAST_SHAPE, (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0));

    public LaserSourceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void GenerateBridge(LevelAccessor world, int length, BlockPos pos, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        AttachFace face = (AttachFace)state.getValue(FACE);
        Boolean bridgeEnded = false;
        for (int i = 1; i < 15; ++i) {
            BlockPos addPos = new BlockPos(0, 0, 0);
            BlockState bs = (BlockState)((BlockState)((Block)LaserBridges.LASER_BLOCK.get()).defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue(FACE, (Comparable)face);
            switch (face) {
                case FLOOR: {
                    addPos = new BlockPos(0, i, 0);
                    break;
                }
                case WALL: {
                    switch (dir) {
                        case EAST: {
                            addPos = new BlockPos(i, 0, 0);
                            break;
                        }
                        case WEST: {
                            addPos = new BlockPos(-i, 0, 0);
                            break;
                        }
                        case SOUTH: {
                            addPos = new BlockPos(0, 0, i);
                            break;
                        }
                        case NORTH: {
                            addPos = new BlockPos(0, 0, -i);
                        }
                    }
                    break;
                }
                case CEILING: {
                    addPos = new BlockPos(0, -i, 0);
                }
            }
            BlockPos nextPos = pos.offset((Vec3i)addPos);
            if (!world.getBlockState(nextPos).isAir() && !world.getBlockState(nextPos).equals(bs)) {
                return;
            }
            if (!bridgeEnded.booleanValue() && i < length) {
                world.setBlock(pos.offset((Vec3i)addPos), bs, 3);
                continue;
            }
            bridgeEnded = true;
            world.setBlock(pos.offset((Vec3i)addPos), Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public void neighborChanged(BlockState state, Level lvl, BlockPos pos, Block p_55669_, BlockPos p_55670_, boolean p_55671_) {
        if (lvl.isClientSide) {
            return;
        }
        int redstonePower = lvl.getBestNeighborSignal(pos);
        boolean flag = (Boolean)state.getValue((Property)POWERED);
        if (flag != lvl.hasNeighborSignal(pos)) {
            if (flag) {
                lvl.scheduleTick(pos, (Block)this, 4);
            } else {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                lvl.playSound((Player)null, pos, (SoundEvent)LaserBridges.ON.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
                this.GenerateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        } else if (flag) {
            lvl.scheduleTick(pos, (Block)this, 4);
        }
    }

    public void tick(BlockState state, ServerLevel lvl, BlockPos pos, RandomSource p_221940_) {
        if (lvl.isClientSide) {
            return;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!lvl.hasNeighborSignal(pos)) {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                this.GenerateBridge((LevelAccessor)lvl, 0, pos, state);
                lvl.playSound((Player)null, pos, (SoundEvent)LaserBridges.OFF.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            } else {
                int redstonePower = lvl.getBestNeighborSignal(pos);
                this.GenerateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        }
    }

    public void onPlace(BlockState state, Level lvl, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        if (lvl.isClientSide) {
            return;
        }
        boolean bl = (Boolean)state.getValue((Property)POWERED);
        if (bl != lvl.hasNeighborSignal(pos)) {
            if (bl) {
                lvl.scheduleTick(pos, (Block)this, 4);
            } else {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                lvl.playSound((Player)null, pos, (SoundEvent)LaserBridges.ON.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
                int redstone = lvl.getBestNeighborSignal(pos);
                this.GenerateBridge((LevelAccessor)lvl, redstone, pos, state);
            }
        }
    }

    public void onRemove(BlockState state, Level lvl, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        if (!lvl.isClientSide) {
            lvl.playSound((Player)null, pos, SoundEvents.METAL_BREAK, SoundSource.BLOCKS, 0.3f, 0.5f);
            this.GenerateBridge((LevelAccessor)lvl, 0, pos, state);
            lvl.playSound((Player)null, pos, (SoundEvent)LaserBridges.OFF.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
        }
    }

    public BlockState updateShape(BlockState state, Direction p_53191_, BlockState statea, LevelAccessor lvl, BlockPos pos, BlockPos p_53195_) {
        if (!state.canSurvive((LevelReader)lvl, pos)) {
            this.GenerateBridge(lvl, 0, pos, state);
            lvl.playSound((Player)null, pos, (SoundEvent)LaserBridges.ON.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        switch ((AttachFace)state.getValue(FACE)) {
            case FLOOR: {
                if (dir.getAxis() == Direction.Axis.X) {
                    return powered ? FLOOR_X_POWERED_SHAPE : FLOOR_X_SHAPE;
                }
                return powered ? FLOOR_Z_POWERED_SHAPE : FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch (dir) {
                    case EAST: {
                        return powered ? EAST_POWERED_SHAPE : EAST_SHAPE;
                    }
                    case WEST: {
                        return powered ? WEST_POWERED_SHAPE : WEST_SHAPE;
                    }
                    case SOUTH: {
                        return powered ? SOUTH_POWERED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return powered ? NORTH_POWERED_SHAPE : NORTH_SHAPE;
            }
        }
        if (dir.getAxis() == Direction.Axis.X) {
            return powered ? CEILING_X_POWERED_SHAPE : CEILING_X_SHAPE;
        }
        return powered ? CEILING_Z_POWERED_SHAPE : CEILING_Z_SHAPE;
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{FACE});
    }
}

