/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import io.github.projectet.ae2things.client.AE2ThingsClient;
import io.github.projectet.ae2things.command.Command;
import io.github.projectet.ae2things.gui.cell.DISKItemCellGuiHandler;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.util.StorageManager;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="ae2things")
public class AE2Things {
    public static final String MOD_ID = "ae2things";
    public static StorageManager STORAGE_INSTANCE = new StorageManager();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ae2things");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public AE2Things(IEventBus modEventBus, Dist dist) {
        ITEMS.register(modEventBus);
        AETItems.init();
        modEventBus.addListener(AE2Things::commonSetup);
        modEventBus.addListener(AE2Things::addContentsToCreativeTab);
        NeoForge.EVENT_BUS.addListener(Command::commandRegister);
        NeoForge.EVENT_BUS.addListener(AE2Things::worldTick);
        if (dist.isClient()) {
            AE2ThingsClient.init(modEventBus);
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        AETItems.commonSetup();
        StorageCells.addCellHandler((ICellHandler)DISKCellHandler.INSTANCE);
        StorageCells.addCellGuiHandler((ICellGuiHandler)new DISKItemCellGuiHandler());
        event.enqueueWork(() -> {
            String disksText = "text.ae2things.disk_drives";
            for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
                Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
            }
        });
    }

    public static void addContentsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (!event.getTabKey().equals(AECreativeTabIds.MAIN)) {
            return;
        }
        event.accept(AETItems.DISK_HOUSING);
        for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
            event.accept((ItemLike)cell.get());
        }
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            STORAGE_INSTANCE = StorageManager.getInstance(event.level.getServer());
        }
    }
}

