/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.item;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.hooks.AEToolItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DISKDrive
extends Item
implements IDISKCellItem,
AEToolItem {
    private final int bytes;
    private final double idleDrain;
    private final ItemLike coreItem;

    public DISKDrive(ItemLike coreItem, int kilobytes, double idleDrain) {
        super(new Item.Properties().stacksTo(1).fireResistant());
        this.bytes = kilobytes * 1000;
        this.coreItem = coreItem;
        this.idleDrain = idleDrain;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.bytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(Set.of(this.getKeyType()), (ItemStack)is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.getOrCreateTag().getString("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.getOrCreateTag().putString("FuzzyMode", fzMode.name());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    @Nullable
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)2);
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            KeyCounter list;
            if (level.isClientSide()) {
                return false;
            }
            Inventory playerInventory = player.getInventory();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && playerInventory.getSelected() == stack && (list = inv.getAvailableStacks()).isEmpty()) {
                playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
                playerInventory.placeItemBackInInventory(new ItemStack(this.coreItem));
                for (ItemStack upgrade : this.getUpgrades(stack)) {
                    playerInventory.placeItemBackInInventory(upgrade);
                }
                playerInventory.placeItemBackInInventory(new ItemStack((ItemLike)AETItems.DISK_HOUSING.get()));
                return true;
            }
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.getLevel(), context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.literal((String)"Deep Item Storage disK - Storage for dummies").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        this.addCellInformationToTooltip(stack, tooltip);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            DISKCellInventory cellInv = DISKCellHandler.INSTANCE.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getClientStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        return 0xFFFFFF;
    }
}

