/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class DataStorage {
    public static final DataStorage EMPTY = new DataStorage();
    public ListTag stackKeys;
    public long[] stackAmounts;
    public long itemCount;

    public DataStorage() {
        this.stackKeys = new ListTag();
        this.stackAmounts = new long[0];
        this.itemCount = 0L;
    }

    public DataStorage(ListTag stackKeys, long[] stackAmounts, long itemCount) {
        this.stackKeys = stackKeys;
        this.stackAmounts = stackAmounts;
        this.itemCount = itemCount;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("keys", (Tag)this.stackKeys);
        nbt.putLongArray("amts", this.stackAmounts);
        if (this.itemCount != 0L) {
            nbt.putLong("ic", this.itemCount);
        }
        return nbt;
    }

    public static DataStorage fromNbt(CompoundTag nbt) {
        long itemCount = 0L;
        ListTag stackKeys = nbt.getList("keys", 10);
        long[] stackAmounts = nbt.getLongArray("amts");
        if (nbt.contains("ic")) {
            itemCount = nbt.getLong("ic");
        }
        return new DataStorage(stackKeys, stackAmounts, itemCount);
    }
}

