/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import io.github.projectet.ae2things.util.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class StorageManager
extends SavedData {
    private static final SavedData.Factory<StorageManager> FACTORY = new SavedData.Factory(StorageManager::new, StorageManager::readNbt);
    private final Map<UUID, DataStorage> disks;

    public StorageManager() {
        this.disks = new HashMap<UUID, DataStorage>();
        this.setDirty();
    }

    private StorageManager(Map<UUID, DataStorage> disks) {
        this.disks = disks;
        this.setDirty();
    }

    public CompoundTag save(CompoundTag nbt) {
        ListTag diskList = new ListTag();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            CompoundTag disk = new CompoundTag();
            disk.putUUID("diskuuid", entry.getKey());
            disk.put("diskdata", (Tag)entry.getValue().toNbt());
            diskList.add((Object)disk);
        }
        nbt.put("disklist", (Tag)diskList);
        return nbt;
    }

    public static StorageManager readNbt(CompoundTag nbt) {
        HashMap<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();
        ListTag diskList = nbt.getList("disklist", 10);
        for (int i = 0; i < diskList.size(); ++i) {
            CompoundTag disk = diskList.getCompound(i);
            disks.put(disk.getUUID("diskuuid"), DataStorage.fromNbt(disk.getCompound("diskdata")));
        }
        return new StorageManager(disks);
    }

    public void updateDisk(UUID uuid, DataStorage dataStorage) {
        this.disks.put(uuid, dataStorage);
        this.setDirty();
    }

    public void removeDisk(UUID uuid) {
        this.disks.remove(uuid);
        this.setDirty();
    }

    public boolean hasUUID(UUID uuid) {
        return this.disks.containsKey(uuid);
    }

    public DataStorage getOrCreateDisk(UUID uuid) {
        if (!this.disks.containsKey(uuid)) {
            this.updateDisk(uuid, new DataStorage());
        }
        return this.disks.get(uuid);
    }

    public void modifyDisk(UUID diskID, ListTag stackKeys, long[] stackAmounts, long itemCount) {
        DataStorage diskToModify = this.getOrCreateDisk(diskID);
        if (stackKeys != null && stackAmounts != null) {
            diskToModify.stackKeys = stackKeys;
            diskToModify.stackAmounts = stackAmounts;
        }
        diskToModify.itemCount = itemCount;
        this.updateDisk(diskID, diskToModify);
    }

    public static StorageManager getInstance(MinecraftServer server) {
        ServerLevel world = server.getLevel(ServerLevel.OVERWORLD);
        return (StorageManager)world.getDataStorage().computeIfAbsent(FACTORY, "disk_manager");
    }
}

