/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class GuiContainerOpenTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(Instance::player), (App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"container_class").forGetter(Instance::containerClass)).apply((Applicative)p_311401_, Instance::new));

    public GuiContainerOpenTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEvent(PlayerContainerEvent.Open event) {
        if (event.getEntity() != null && event.getEntity() instanceof ServerPlayer) {
            this.trigger((ServerPlayer)event.getEntity(), i -> i.test((ServerPlayer)event.getEntity(), event.getContainer()));
        }
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<String> containerClass) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<AbstractContainerMenu>
    {
        @Override
        public boolean test(ServerPlayer player, AbstractContainerMenu container) {
            return this.containerClass.map(className -> {
                Class<?> clazz;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Could not find the container class with name '" + className + "'");
                }
                return clazz != null && clazz.isInstance(container);
            }).orElse(true);
        }
    }
}

