/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class ItemCraftedTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(Instance::player), (App)ItemPredicate.CODEC.fieldOf("item").forGetter(Instance::itemPredicate)).apply((Applicative)p_311401_, Instance::new));

    public ItemCraftedTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof ServerPlayer) {
            this.trigger((ServerPlayer)event.getEntity(), i -> i.test((ServerPlayer)event.getEntity(), event));
        }
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, ItemPredicate itemPredicate) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<PlayerEvent.ItemCraftedEvent>
    {
        @Override
        public boolean test(ServerPlayer player, PlayerEvent.ItemCraftedEvent criterionData) {
            return this.itemPredicate.matches(criterionData.getCrafting());
        }
    }
}

