/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.EntityItemPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class ModItemObtainedTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(Instance::player), (App)Codec.STRING.fieldOf("mod_id").forGetter(Instance::modId)).apply((Applicative)p_311401_, Instance::new));

    public ModItemObtainedTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof ServerPlayer) {
            this.trigger((ServerPlayer)event.getEntity(), i -> i.test((ServerPlayer)event.getEntity(), event.getItem().getItem()));
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof ServerPlayer) {
            this.trigger((ServerPlayer)event.getEntity(), i -> i.test((ServerPlayer)event.getEntity(), event.getCrafting()));
        }
    }

    @SubscribeEvent
    public void onSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof ServerPlayer) {
            this.trigger((ServerPlayer)event.getEntity(), i -> i.test((ServerPlayer)event.getEntity(), event.getSmelting()));
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, String modId) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<ItemStack>
    {
        @Override
        public boolean test(ServerPlayer player, ItemStack itemStack) {
            return !itemStack.isEmpty() && BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace().equals(this.modId);
        }
    }
}

