/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;

public abstract class BlockWithEntity
extends BaseEntityBlock {
    private final BiFunction<BlockPos, BlockState, CyclopsBlockEntity> blockEntitySupplier;

    public BlockWithEntity(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, CyclopsBlockEntity> blockEntitySupplier) {
        super(properties);
        this.blockEntitySupplier = blockEntitySupplier;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntitySupplier.apply(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos blockPos, Player player) {
        ItemStack itemStack = this.getDroppedItemStack(state, target, (BlockGetter)world, blockPos, player, super.getCloneItemStack(state, target, world, blockPos, player));
        if (this.isPersistNbt()) {
            BlockEntityHelpers.get((BlockGetter)world, blockPos, CyclopsBlockEntity.class).ifPresent(blockEntity -> {
                CompoundTag compoundnbt = this.getDroppedItemStackNbt(state, target, (BlockGetter)world, blockPos, player, itemStack, (CyclopsBlockEntity)blockEntity);
                if (!compoundnbt.isEmpty()) {
                    itemStack.addTagElement("BlockEntityTag", (Tag)compoundnbt);
                }
            });
        }
        return itemStack;
    }

    public BlockState playerWillDestroy(Level world, BlockPos blockPos, BlockState blockState, Player player) {
        return super.playerWillDestroy(world, blockPos, blockState, player);
    }

    protected ItemStack getDroppedItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack originalItemStack) {
        return originalItemStack;
    }

    protected CompoundTag getDroppedItemStackNbt(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack itemStack, CyclopsBlockEntity blockEntity) {
        return blockEntity.writeToItemStack(new CompoundTag());
    }

    public boolean isPersistNbt() {
        return false;
    }
}

