/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class HollowCubeDetector
extends CubeDetector {
    public HollowCubeDetector(AllowedBlock[] allowedBlocks, List<? extends CubeDetector.IDetectionListener> listeners) {
        super(allowedBlocks, listeners);
    }

    @Override
    protected void postValidate(LevelReader world, final Vec3i size, final int[][] dimensionEgdes, final boolean valid, final BlockPos originCorner, final BlockPos excludeLocation) {
        this.coordinateRecursion(world, dimensionEgdes, new CubeDetector.BlockPosAction(){

            @Override
            public boolean run(LevelReader world, BlockPos location) {
                if (HollowCubeDetector.this.isEdge(world, dimensionEgdes, location) && HollowCubeDetector.this.isValidLocation(world, location, excludeLocation) == null) {
                    HollowCubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                }
                return true;
            }
        });
    }

    @Override
    protected Component validateLocationInStructure(LevelReader world, int[][] dimensionEgdes, BlockPos location, CubeDetector.IValidationAction action, BlockPos excludeLocation) {
        if (this.isEdge(world, dimensionEgdes, location)) {
            Component error = this.isValidLocation(world, location, action, excludeLocation);
            if (error != null) {
                return error;
            }
        } else if (!this.isAir(world, location)) {
            return Component.translatable((String)"multiblock.cyclopscore.error.hollow.air", (Object[])new Object[]{LocationHelpers.toCompactString(location)});
        }
        return null;
    }
}

